<?php
namespace Mainto\Bridge\Invokes\ManageAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPermissionListByParams(array $params)
 * @method createPermissionByParams(array $params)
 * @method deletePermissionByParams(array $params)
 */
class Permission {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过应用ID获取权限列表
     *
     * @param  int $appid 应用ID [ require true ]
     * @param  string $name 权限名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissionList (int $appid, string $name = '') {
        return self::getClass()->getPermissionList([
            "appid" => $appid,
            "name" => $name,
        ]);
    }

    /**
     * 创建权限
     *
     * @param  int $appid 应用ID [ require true ]
     * @param  string $name 权限标示 [ require true ]
     * @param  string $title 权限名 [ require true ]
     * @param  string $desc 权限描述 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPermission (int $appid, string $name, string $title, string $desc = '') {
        return self::getClass()->createPermission([
            "appid" => $appid,
            "name" => $name,
            "title" => $title,
            "desc" => $desc,
        ]);
    }

    /**
     * 删除权限
     *
     * @param  int $permissionId 权限ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deletePermission (int $permissionId) {
        return self::getClass()->deletePermission([
            "permissionId" => $permissionId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ManageAuth', 'Permission');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ManageAuth', 'Permission');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}