<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createDsByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method detailByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method orderCountByParams(array $params)
 * @method startOrderByParams(array $params)
 * @method editOrderByParams(array $params)
 * @method deleteDsByParams(array $params)
 * @method storeStaffByParams(array $params)
 * @method interiorReviewByParams(array $params)
 * @method restoreByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表
     *
     * @support  string $state 订单状态 
     * @support  string $pay_type 支付类型 
     * @support  string $phone 手机号 
     * @support  string $name 用户姓名 
     * @support  string $order_num 订单号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 录入ds
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @support  float $money ds金额 [Original type double] [ require true ]
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  string $type ds类型 [ require true ]
     * @support  int $product_id 产品id 
     * @support  int $old_product_id 旧产品id 
     * @support  int $sku_id 产品sku_id 
     * @support  int $count 拍摄人数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createDs () {
        return self::getClass()->createDs();
    }

    /**
     * 添加订单
     *
     * @support  string $name 用户姓名 [ require true ]
     * @support  string $state 订单状态 
     * @support  string $birthday 用户生日 [ require true ]
     * @support  string $sex 用户性别 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  float $money 支付金额 [Original type double] [ require true ]
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  string $note 备注 
     * @support  string $code 开单折扣码 
     * @support  array $products 产品信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 订单详情
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 关闭订单
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder () {
        return self::getClass()->closeOrder();
    }

    /**
     * 订单数量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderCount () {
        return self::getClass()->orderCount();
    }

    /**
     * 开始订单流程
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startOrder () {
        return self::getClass()->startOrder();
    }

    /**
     * 修改订单
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  string $pay_type 支付方式 
     * @support  string $reserve_time 预约时间 
     * @support  string $sex 性别 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editOrder () {
        return self::getClass()->editOrder();
    }

    /**
     * 删除ds
     *
     * @support  int $ds_id 时间节点 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteDs () {
        return self::getClass()->deleteDs();
    }

    /**
     * 获取员工列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeStaff () {
        return self::getClass()->storeStaff();
    }

    /**
     * 使用开单折扣码
     *
     * @support  string $code 开单折扣码 
     * @throws  \Exception
     * @return  mixed
     */
    public static function interiorReview () {
        return self::getClass()->interiorReview();
    }

    /**
     * 恢复订单
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function restore () {
        return self::getClass()->restore();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}