<?php
namespace Mainto\Bridge\Invokes\Kids\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addWorkloadByParams(array $params)
 * @method getOrderProductByParams(array $params)
 * @method getProductsByParams(array $params)
 * @method getOrderDsByParams(array $params)
 * @method storesByParams(array $params)
 * @method workloadsByParams(array $params)
 * @method staffsByParams(array $params)
 * @method npsByParams(array $params)
 */
class Cloud {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 录入看片师工作量
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @support  int $work_per 工作量 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addWorkload () {
        return self::getClass()->addWorkload();
    }

    /**
     * 获取订单产品
     *
     * @support  string $order_num 订单号 
     * @support  string $name 姓名 
     * @support  string $phone 手机号 
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderProduct () {
        return self::getClass()->getOrderProduct();
    }

    /**
     * 获取产品
     *
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProducts () {
        return self::getClass()->getProducts();
    }

    /**
     * 根据订单查二销产品
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderDs () {
        return self::getClass()->getOrderDs();
    }

    /**
     * 门店信息
     *
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stores () {
        return self::getClass()->stores();
    }

    /**
     * 获取工作量
     *
     * @support  string $token token [ require true ]
     * @support  array $order_nums 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function workloads () {
        return self::getClass()->workloads();
    }

    /**
     * 获取员工信息
     *
     * @support  string $token token [ require true ]
     * @support  array $staff_ids 员工工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function staffs () {
        return self::getClass()->staffs();
    }

    /**
     * 获取对应订单的nps
     *
     * @support  string $token token [ require true ]
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function nps () {
        return self::getClass()->nps();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Extend\Cloud');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Extend\Cloud');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}