<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method staffByParams(array $params)
 * @method staffCountByParams(array $params)
 * @method staffExportByParams(array $params)
 * @method storeByParams(array $params)
 * @method storeCountByParams(array $params)
 * @method storeExportByParams(array $params)
 */
class Nps {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 个人nps列表
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $end_time 查询的结束时间 [ require true ]
     * @support  int $staff_id 员工id 
     * @support  int $store_id 门店id [ require true ]
     * @support  string $staff_type 岗位类型 
     * @support  int $score 评价得分 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function staff () {
        return self::getClass()->staff();
    }

    /**
     * 个人nps数量统计
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $end_time 查询的结束时间 [ require true ]
     * @support  int $staff_id 员工id 
     * @support  int $store_id 门店id [ require true ]
     * @support  string $staff_type 岗位类型 
     * @support  int $score 评价得分 
     * @throws  \Exception
     * @return  array
     */
    public static function staffCount () {
        return self::getClass()->staffCount();
    }

    /**
     * 个人nps导出
     *
     * @throws  \Exception
     * @return  array
     */
    public static function staffExport () {
        return self::getClass()->staffExport();
    }

    /**
     * 门店nps列表
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $end_time 查询的结束时间 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  string $staff_type 岗位筛选 
     * @support  int $score 评价得分 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function store () {
        return self::getClass()->store();
    }

    /**
     * 门店nps数量统计
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $end_time 查询的结束时间 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  string $staff_type 岗位类型 
     * @support  int $score 评价得分 
     * @throws  \Exception
     * @return  array
     */
    public static function storeCount () {
        return self::getClass()->storeCount();
    }

    /**
     * 门店nps导出
     *
     * @support  string $start_time 导出的开始时间 [ require true ]
     * @support  string $end_time 导出的结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeExport () {
        return self::getClass()->storeExport();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\Nps');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\Nps');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}