<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method incomeCreateByParams(array $params)
 * @method incomeListByParams(array $params)
 * @method incomeDeleteByParams(array $params)
 * @method disburseCreateByParams(array $params)
 * @method disburseListByParams(array $params)
 * @method disburseReviewByParams(array $params)
 * @method disburseCertificateByParams(array $params)
 */
class Turnover {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 线下收入录入
     *
     * @support  string $expense_time 取款时间 [ require true ]
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  float $money 录入金额 [Original type double] [ require true ]
     * @support  string $cash_item 录入项目 [ require true ]
     * @support  string $note 备注 [ require true ]
     * @support  string $order_num 对应订单号 
     * @support  string $sell_type 售卖方式 
     * @throws  \Exception
     * @return  array
     */
    public static function incomeCreate () {
        return self::getClass()->incomeCreate();
    }

    /**
     * 线下收入列表
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  string $pay_type 支付类型 
     * @support  int $store_id 门店id [ require true ]
     * @support  string $cash_item 录入项目 
     * @support  int $recorder_id 录入人 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function incomeList () {
        return self::getClass()->incomeList();
    }

    /**
     * 线下收入/支出删除
     *
     * @support  int $turnover_id 收入id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function incomeDelete () {
        return self::getClass()->incomeDelete();
    }

    /**
     * 线下支出录入
     *
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  float $money 录入金额 [Original type double] [ require true ]
     * @support  string $cash_item 录入项目 [ require true ]
     * @support  string $note 备注 [ require true ]
     * @support  string $path 凭证路径 [ require true ]
     * @support  int $remittee 取款人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disburseCreate () {
        return self::getClass()->disburseCreate();
    }

    /**
     * 线下支出列表
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  string $pay_type 支付类型 
     * @support  int $store_id 门店id [ require true ]
     * @support  string $cash_item 录入项目 
     * @support  int $recorder_id 录入人 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function disburseList () {
        return self::getClass()->disburseList();
    }

    /**
     * 线下支出审核
     *
     * @support  int $disburse_id 支出id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disburseReview () {
        return self::getClass()->disburseReview();
    }

    /**
     * 线下支出查看凭证
     *
     * @support  int $disburse_id 支出id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disburseCertificate () {
        return self::getClass()->disburseCertificate();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\Turnover');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\Turnover');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}