<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method notShootByParams(array $params)
 * @method changeStoreByParams(array $params)
 * @method dsByParams(array $params)
 * @method productDataByParams(array $params)
 * @method closeTimeNodesByParams(array $params)
 * @method globalOrderByParams(array $params)
 * @method checkOrderByParams(array $params)
 * @method closeModeListByParams(array $params)
 * @method closeModeTimeByParams(array $params)
 */
class Tools {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 工具-未拍摄订单导出
     *
     * @support  string $query_time 查询时间 
     * @throws  \Exception
     * @return  array
     */
    public static function notShoot () {
        return self::getClass()->notShoot();
    }

    /**
     * 工具-转门店数据明细
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  array $old_store_id 原门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeStore () {
        return self::getClass()->changeStore();
    }

    /**
     * 工具-二销数据导出
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  array $store_id 门店id [ require true ]
     * @support  string $ds_type 二销类型 [ require true ]
     * @support  array $old_product_id 原拍摄产品 
     * @support  array $product_id 产品id 
     * @support  array $new_product_id 升级拍摄产品 
     * @throws  \Exception
     * @return  array
     */
    public static function ds () {
        return self::getClass()->ds();
    }

    /**
     * 工具-产品销量数据
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  array $store_id 门店id [ require true ]
     * @support  array $product_id 产品id 
     * @throws  \Exception
     * @return  array
     */
    public static function productData () {
        return self::getClass()->productData();
    }

    /**
     * 工具-批量关闭时间点
     *
     * @support  string $start_time 开始时间 [ require true ]
     * @support  string $end_time 结束时间 [ require true ]
     * @support  int $sign 关闭席位 [ require true ]
     * @support  string $close_reason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeTimeNodes () {
        return self::getClass()->closeTimeNodes();
    }

    /**
     * 工具-全局订单查询
     *
     * @support  string $phone 手机号 
     * @support  string $order_num 订单号 
     * @support  string $name 姓名 
     * @throws  \Exception
     * @return  mixed
     */
    public static function globalOrder () {
        return self::getClass()->globalOrder();
    }

    /**
     * 工具-查账助手
     *
     * @support  string $start_time 开始时间 [ require true ]
     * @support  string $end_time 结束时间 [ require true ]
     * @support  string $account_type 查账类型 
     * @support  string $order_from 订单来源 [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOrder () {
        return self::getClass()->checkOrder();
    }

    /**
     * 工具-批量关闭时间点展示
     *
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeModeList () {
        return self::getClass()->closeModeList();
    }

    /**
     * 工具-批量关闭时间点记录删除
     *
     * @support  int $_id 记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeModeTime () {
        return self::getClass()->closeModeTime();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\Tools');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\Tools');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}