<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method staffByParams(array $params)
 * @method exportStaffByParams(array $params)
 * @method storePerformanceByParams(array $params)
 * @method totalByParams(array $params)
 * @method storeByParams(array $params)
 * @method totalEffectByParams(array $params)
 * @method storeTargetByParams(array $params)
 * @method targetListByParams(array $params)
 * @method destroyTargetByParams(array $params)
 * @method deleteTargetByParams(array $params)
 * @method exportTotalByParams(array $params)
 * @method exportMouthTotalByParams(array $params)
 */
class Performance {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 个人绩效查询
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询开始时间 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staff () {
        return self::getClass()->staff();
    }

    /**
     * 个人绩效导出
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询开始时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exportStaff () {
        return self::getClass()->exportStaff();
    }

    /**
     * 门店绩效查询(新版)
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询开始时间 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storePerformance () {
        return self::getClass()->storePerformance();
    }

    /**
     * 总体绩效查询(新版)
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询开始时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function total () {
        return self::getClass()->total();
    }

    /**
     * 门店绩效查询
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询开始时间 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function store () {
        return self::getClass()->store();
    }

    /**
     * 总体绩效查询
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询开始时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function totalEffect () {
        return self::getClass()->totalEffect();
    }

    /**
     * 门店目标业绩
     *
     * @support  string $month 录入月份 [ require true ]
     * @support  array $targets 目标数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeTarget () {
        return self::getClass()->storeTarget();
    }

    /**
     * 门店目标业绩查询
     *
     * @support  string $month 录入月份 [ require true ]
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function targetList () {
        return self::getClass()->targetList();
    }

    /**
     * 清空门店目标业绩
     *
     * @support  string $month 录入月份 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function destroyTarget () {
        return self::getClass()->destroyTarget();
    }

    /**
     * 删除门店目标业绩
     *
     * @support  int $_id 记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteTarget () {
        return self::getClass()->deleteTarget();
    }

    /**
     * 总体绩效导出(按日)
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exportTotal () {
        return self::getClass()->exportTotal();
    }

    /**
     * 总体绩效导出(按月)
     *
     * @support  string $query_month 查询月份 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exportMouthTotal () {
        return self::getClass()->exportMouthTotal();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\Performance');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\Performance');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}