<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method staffInfoByParams(array $params)
 * @method setStoreByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 * @method getHostByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有的权限
     *
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取管理员信息
     *
     * @support  string $staffName 姓名或花名 
     * @support  string $type 类型(core总部|himo_store门店) 
     * @throws  \Exception
     * @return  array
     */
    public static function staffInfo () {
        return self::getClass()->staffInfo();
    }

    /**
     * 切换门店
     *
     * @support  int $store_id 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setStore () {
        return self::getClass()->setStore();
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 获取Host地址
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}