<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method priceByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品列表
     *
     * @support  int $with_del 是否包含删除的数据 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 产品详情
     *
     * @support  int $product_id 产品id 
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 产品价格
     *
     * @support  int $product_id 产品id [ require true ]
     * @support  int $count 人数 [ require true ]
     * @support  int $sku_id skuid 
     * @throws  \Exception
     * @return  array
     */
    public static function price () {
        return self::getClass()->price();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}