<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createManagerByParams(array $params)
 * @method lockManagerByParams(array $params)
 * @method startManagerByParams(array $params)
 * @method deleteManagerByParams(array $params)
 * @method createPermissionByParams(array $params)
 */
class Manage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有的管理员
     *
     * @support  int $staff_id 工号 
     * @support  string $name 姓名 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 添加管理员
     *
     * @support  int $staff_id 工号 [ require true ]
     * @support  string $name 姓名 [ require true ]
     * @support  string $type 类型(core总部|himo_store门店) [ require true ]
     * @support  string $nickname 花名 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createManager () {
        return self::getClass()->createManager();
    }

    /**
     * 停用管理员账号
     *
     * @support  int $staff_id staff_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function lockManager () {
        return self::getClass()->lockManager();
    }

    /**
     * 启用管理员账号
     *
     * @support  int $staff_id staff_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startManager () {
        return self::getClass()->startManager();
    }

    /**
     * 删除管理员
     *
     * @support  int $staff_id staff_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteManager () {
        return self::getClass()->deleteManager();
    }

    /**
     * 给当前伙伴设置权限
     *
     * @support  int $staff_id staff_id [ require true ]
     * @support  string $type 身份标志 [ require true ]
     * @support  array $permission_ids 权限ids [ require true ]
     * @support  array $new_store_ids 新增门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPermission () {
        return self::getClass()->createPermission();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\Manage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\Manage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}