<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method staffByParams(array $params)
 * @method exportStaffByParams(array $params)
 * @method storeByParams(array $params)
 * @method totalByParams(array $params)
 * @method storeTargetByParams(array $params)
 * @method exportTotalByParams(array $params)
 * @method exportMouthTotalByParams(array $params)
 */
class Performance {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 个人绩效查询
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询开始时间 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staff () {
        return self::getClass()->staff();
    }

    /**
     * 个人绩效导出
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询开始时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exportStaff () {
        return self::getClass()->exportStaff();
    }

    /**
     * 门店绩效查询
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询开始时间 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function store () {
        return self::getClass()->store();
    }

    /**
     * 总体绩效查询
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询开始时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function total () {
        return self::getClass()->total();
    }

    /**
     * 总体绩效查询
     *
     * @support  string $month 录入月份 [ require true ]
     * @support  array $targets 目标数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeTarget () {
        return self::getClass()->storeTarget();
    }

    /**
     * 总体绩效导出(按日)
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exportTotal () {
        return self::getClass()->exportTotal();
    }

    /**
     * 总体绩效导出(按月)
     *
     * @support  string $query_month 查询月份 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exportMouthTotal () {
        return self::getClass()->exportMouthTotal();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\Performance');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\Performance');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}