<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method userCouponByParams(array $params)
 * @method createByParams(array $params)
 * @method bindCouponByParams(array $params)
 * @method changeCouponByParams(array $params)
 * @method deleteByParams(array $params)
 * @method interiorListByParams(array $params)
 * @method createInteriorByParams(array $params)
 * @method interiorDetailByParams(array $params)
 * @method createActivityByParams(array $params)
 * @method activityByParams(array $params)
 * @method interiorReviewByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 优惠券列表
     *
     * @support  string $type 类型(产品券|立减券) 
     * @support  int $title 对应活动 
     * @support  string $code 优惠码 
     * @support  string $state 使用状态 
     * @support  string $start_time 查询开始时间 
     * @support  string $end_time 查询结束时间 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 查询用户优惠券
     *
     * @support  string $phone 用户手机号 [ require true ]
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function userCoupon () {
        return self::getClass()->userCoupon();
    }

    /**
     * 添加优惠券
     *
     * @support  string $type 优惠券类型(产品全|立减券) [ require true ]
     * @support  int $count 生成数量 [ require true ]
     * @support  string $expire_time 到期时间 [ require true ]
     * @support  string $available_time 开始使用时间 [ require true ]
     * @support  int $money 优惠金额 [ require true ]
     * @support  int $product 所属产品 
     * @support  int $activity 对应活动 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 绑定用户优惠券
     *
     * @support  string $phone 用户手机号 [ require true ]
     * @support  string $code 优惠码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindCoupon () {
        return self::getClass()->bindCoupon();
    }

    /**
     * 更改优惠券状态
     *
     * @support  string $state 优惠券状态 [ require true ]
     * @support  int $_id 优惠券id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeCoupon () {
        return self::getClass()->changeCoupon();
    }

    /**
     * 删除操作
     *
     * @support  int $_id 优惠券id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 折扣码列表
     *
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function interiorList () {
        return self::getClass()->interiorList();
    }

    /**
     * 添加折扣码
     *
     * @support  int $count 生成数量 [ require true ]
     * @support  string $expire_time 到期时间 [ require true ]
     * @support  int $money 优惠金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createInterior () {
        return self::getClass()->createInterior();
    }

    /**
     * 折扣码详情
     *
     * @support  int $log_id 折扣码id [ require true ]
     * @support  int $page_size 条数 
     * @support  int $page 页码 
     * @throws  \Exception
     * @return  mixed
     */
    public static function interiorDetail () {
        return self::getClass()->interiorDetail();
    }

    /**
     * 添加优惠券对应活动
     *
     * @support  string $name 活动名称 [ require true ]
     * @support  string $type 优惠券类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createActivity () {
        return self::getClass()->createActivity();
    }

    /**
     * 优惠券活动列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function activity () {
        return self::getClass()->activity();
    }

    /**
     * 验证开单折扣码
     *
     * @support  string $code 折扣码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function interiorReview () {
        return self::getClass()->interiorReview();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}