<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加员工
     *
     * @support  int $id 工号 [ require true ]
     * @support  string $name 姓名 [ require true ]
     * @support  string $staff_type 员工类型 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  string $tag 身份标识 
     * @support  string $job_ext 兼岗 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改员工
     *
     * @support  int $id 工号 [ require true ]
     * @support  string $name 姓名 [ require true ]
     * @support  string $staff_type 员工类型 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  string $tag 身份标识 
     * @support  string $job_ext 兼岗 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除员工
     *
     * @support  int $id 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 员工列表
     *
     * @support  int $id 工号 
     * @support  string $name 姓名 
     * @support  int $store_id 门店id 
     * @support  string $staff_type 员工职位 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}