<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createRefundByParams(array $params)
 * @method listByParams(array $params)
 * @method agreeRefundByParams(array $params)
 * @method deleteRefundByParams(array $params)
 */
class OrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款录入
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  string $refund_type 退款类型 [ require true ]
     * @support  string $order_from 订单来源 [ require true ]
     * @support  string $refund_percent 退款比例  [ require true ]
     * @support  float $refund_money 退款金额 [Original type double] [ require true ]
     * @support  string $name 退款人 [ require true ]
     * @support  string $refund_account 退款账号 [ require true ]
     * @support  string $refund_reason 退款原因 [ require true ]
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createRefund () {
        return self::getClass()->createRefund();
    }

    /**
     * 退款列表
     *
     * @support  string $order_num 订单号 
     * @support  int $store_id 门店id 
     * @support  string $refund_reason 退款原因 
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询开始时间 [ require true ]
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 确认退款
     *
     * @support  int $_id 记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function agreeRefund () {
        return self::getClass()->agreeRefund();
    }

    /**
     * 删除退款
     *
     * @support  int $_id 记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteRefund () {
        return self::getClass()->deleteRefund();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\OrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\OrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}