<?php
namespace Mainto\Bridge\Invokes\Kids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method editTimeNoteByParams(array $params)
 * @method countByParams(array $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 排单表列表
     *
     * @support  string $start_time 开始时间 
     * @support  string $end_time 开始时间 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 开放/关闭时间节点
     *
     * @support  string $time_note 时间节点 [ require true ]
     * @support  int $sign 节点序号 [ require true ]
     * @support  string $state 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editTimeNote () {
        return self::getClass()->editTimeNote();
    }

    /**
     * 排单表产品统计
     *
     * @support  string $start_time 开始时间 
     * @support  string $end_time 开始时间 
     * @throws  \Exception
     * @return  array
     */
    public static function count () {
        return self::getClass()->count();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Kids', 'Admin\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Kids', 'Admin\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}