<?php
namespace Mainto\Bridge\Invokes\JavaMaven\Controller;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ExampleController
 */
class ExampleController {
    private static string $serviceName = "JavaMaven";

    private static string $className = "controller.ExampleController";

    /**
     * 
     *
     */
    public static function exampleExceptionBodyArray (): void {
         RpcClass::getClass(self::$serviceName, self::$className)->exampleExceptionBodyArray();
    }
    /**
     * sayHello
     *
     */
    public static function sayHello (?\Mainto\Bridge\Structs\JavaMaven\Controller\ExampleController\SayHelloParams $sayHelloParams = null): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHello($sayHelloParams);
    }
    /**
     * sayHelloWithAuth
     *
     */
    public static function sayHelloWithAuth (?\Mainto\Bridge\Structs\JavaMaven\Controller\ExampleController\SayHelloWithAuthParams $sayHelloWithAuthParams = null): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHelloWithAuth($sayHelloWithAuthParams);
    }
    /**
     * 
     *
     */
    public static function helloPHP (): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->helloPHP();
    }
    /**
     * sayHello.validation
     *
     */
    public static function sayHelloValidation (?\Mainto\Bridge\Structs\JavaMaven\Cmd\SayHelloValidationHobby $sayHelloValidationHobby = null): \Mainto\Bridge\Structs\JavaMaven\Cmd\SayHelloValidationHobby {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->sayHelloValidation($sayHelloValidationHobby),
            "\Mainto\Bridge\Structs\JavaMaven\Cmd\SayHelloValidationHobby"
        );
    }
    /**
     * 
     *
     */
    public static function getRequestIp (): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRequestIp();
    }
    /**
     * 
     *
     */
    public static function usleep (?\Mainto\Bridge\Structs\JavaMaven\Controller\ExampleController\UsleepParams $usleepParams = null): void {
         RpcClass::getClass(self::$serviceName, self::$className)->usleep($usleepParams);
    }
    /**
     * 
     *
     */
    public static function notReportExampleException (): void {
         RpcClass::getClass(self::$serviceName, self::$className)->notReportExampleException();
    }
    /**
     * 
     *
     */
    public static function exampleException (): void {
         RpcClass::getClass(self::$serviceName, self::$className)->exampleException();
    }
    /**
     * setting
     *
     */
    public static function setting (): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->setting();
    }
    /**
     * 
     *
     */
    public static function sleep (?\Mainto\Bridge\Structs\JavaMaven\Controller\ExampleController\SleepParams $sleepParams = null): void {
         RpcClass::getClass(self::$serviceName, self::$className)->sleep($sleepParams);
    }
    /**
     * 获取主机名
     *
     */
    public static function getHostname (?\Mainto\Bridge\Structs\JavaMaven\Controller\ExampleController\GetHostnameParams $getHostnameParams = null): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHostname($getHostnameParams);
    }
    /**
     * 返回错误码未提前定义的错误
     *
     */
    public static function errorExample (): void {
         RpcClass::getClass(self::$serviceName, self::$className)->errorExample();
    }
    /**
     * 返回错误码提前定义的错误
     *
     */
    public static function errorExampleSpecial (): void {
         RpcClass::getClass(self::$serviceName, self::$className)->errorExampleSpecial();
    }
    /**
     * 
     *
     */
    public static function visit (): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->visit();
    }
    /**
     * 
     *
     */
    public static function innerRpcMethod (?\Mainto\Bridge\Structs\JavaMaven\Controller\ExampleController\InnerRpcMethodParams $innerRpcMethodParams = null): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->innerRpcMethod($innerRpcMethodParams);
    }
}