<?php
namespace Mainto\Bridge\Invokes\JavaMaven\Controller;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ExampleController
 */
class ExampleController {
    private static string $serviceName = "JavaMaven";

    private static string $className = "controller.ExampleController";

    /**
     * 
     *
     */
    public static function exampleExceptionBodyArray () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exampleExceptionBodyArray();
    }
    /**
     * sayHello
     *
     */
    public static function sayHello (\Mainto\Bridge\Structs\JavaMaven\Controller\ExampleController\SayHelloParams $sayHelloParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHello($sayHelloParams);
    }
    /**
     * sayHelloWithAuth
     *
     */
    public static function sayHelloWithAuth (\Mainto\Bridge\Structs\JavaMaven\Controller\ExampleController\SayHelloWithAuthParams $sayHelloWithAuthParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHelloWithAuth($sayHelloWithAuthParams);
    }
    /**
     * 
     *
     */
    public static function helloPHP () {
        return RpcClass::getClass(self::$serviceName, self::$className)->helloPHP();
    }
    /**
     * sayHello.validation
     *
     */
    public static function sayHelloValidation (\Mainto\Bridge\Structs\JavaMaven\Cmd\SayHelloValidationHobby $sayHelloValidationHobby) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHelloValidation($sayHelloValidationHobby);
    }
    /**
     * 
     *
     */
    public static function getRequestIp () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRequestIp();
    }
    /**
     * 
     *
     */
    public static function usleep (\Mainto\Bridge\Structs\JavaMaven\Controller\ExampleController\UsleepParams $usleepParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->usleep($usleepParams);
    }
    /**
     * 
     *
     */
    public static function notReportExampleException () {
        return RpcClass::getClass(self::$serviceName, self::$className)->notReportExampleException();
    }
    /**
     * 
     *
     */
    public static function exampleException () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exampleException();
    }
    /**
     * setting
     *
     */
    public static function setting () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setting();
    }
    /**
     * 
     *
     */
    public static function sleep (\Mainto\Bridge\Structs\JavaMaven\Controller\ExampleController\SleepParams $sleepParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sleep($sleepParams);
    }
    /**
     * 获取主机名
     *
     */
    public static function getHostname (\Mainto\Bridge\Structs\JavaMaven\Controller\ExampleController\GetHostnameParams $getHostnameParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHostname($getHostnameParams);
    }
    /**
     * 返回错误码未提前定义的错误
     *
     */
    public static function errorExample () {
        return RpcClass::getClass(self::$serviceName, self::$className)->errorExample();
    }
    /**
     * 返回错误码提前定义的错误
     *
     */
    public static function errorExampleSpecial () {
        return RpcClass::getClass(self::$serviceName, self::$className)->errorExampleSpecial();
    }
    /**
     * 
     *
     */
    public static function visit () {
        return RpcClass::getClass(self::$serviceName, self::$className)->visit();
    }
    /**
     * 
     *
     */
    public static function innerRpcMethod (\Mainto\Bridge\Structs\JavaMaven\Controller\ExampleController\InnerRpcMethodParams $innerRpcMethodParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->innerRpcMethod($innerRpcMethodParams);
    }
}