<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method getListByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Note {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  string $title 标题 [ require true ]
     * @param  string $content 内容 [ require true ]
     * @support  int $from_course 课程id [Original type uint] 
     * @support  string $experience 感悟 
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function create (string $title, string $content, int $staff_num) {
        return self::getClass()->create([
            "title" => $title,
            "content" => $content,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 获取列表分页
     *
     * @support  string $title 标题 
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @support  array $order_by 排序[[&#039;column&#039;, &#039;desc|asc&#039;]] 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $staff_num, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPage([
            "staff_num" => $staff_num,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  string $title 标题 
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $staff_num) {
        return self::getClass()->getList([
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 查看详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $id, int $staff_num) {
        return self::getClass()->getInfo([
            "id" => $id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 更新
     *
     * @support  string $title 标题 
     * @support  string $content 内容 
     * @support  int $from_course 课程id [Original type uint] 
     * @support  string $experience 感悟 
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function update (int $id, int $staff_num) {
        return self::getClass()->update([
            "id" => $id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 删除笔记
     *
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id, int $staff_num) {
        return self::getClass()->delete([
            "id" => $id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'Note');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'Note');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}