<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getExamOriginByParams(array $params)
 * @method getListByGroupsByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListByIdsWithPageByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method releaseByParams(array $params)
 * @method unReleaseByParams(array $params)
 * @method updateExamByParams(array $params)
 * @method getCategoriesByParams(array $params)
 * @method getTypesByParams(array $params)
 */
class Exam {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建试卷
     *
     * @support  string $category 分类名称 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @param  array $can_rule 前置条件 [ require true ]
     * @support  string $name 试卷名称 [ require true ]
     * @param  int $time 限时(秒) [ require true ]
     * @support  string $description 试卷描述 
     * @param  int $pass_score 通过分数 [ require true ]
     * @param  int $pass_credit 通过学分 [ require true ]
     * @param  array $question_config 题型配置 [ require true ]
     * @support  array $questions 题目 
     * @support  array $question_ids 题目ids [Original type array&lt;int&gt;] 
     * @support  array $extend 其他配置(随意) 
     * @support  int $course_id 课程id 
     * @support  array $group_ids 分组ids [Original type array&lt;int&gt;] 
     * @support  array $answer_times_limit 回答次数 
     * @support  array $score_item 评分项 
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $pass_score, int $pass_credit, array $question_config, array $can_rule = [], int $time = 0) {
        return self::getClass()->create([
            "pass_score" => $pass_score,
            "pass_credit" => $pass_credit,
            "question_config" => $question_config,
            "can_rule" => $can_rule,
            "time" => $time,
        ]);
    }

    /**
     * 获取试卷详细信息
     *
     * @param  int $id 试卷id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExamOrigin (int $id) {
        return self::getClass()->getExamOrigin([
            "id" => $id,
        ]);
    }

    /**
     * getListByGroups
     *
     * @param  array $group_ids 分组ids [Original type array&lt;int&gt;] [ require true ]
     * @support  string $category 试卷分类 
     * @support  int $staff_num 工号 
     * @support  bool $is_released 是否上线 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByGroups (array $group_ids, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByGroups([
            "group_ids" => $group_ids,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取试卷列表不分页
     *
     * @support  string $category 试卷分类 
     * @support  int $is_released 是否上线状态 
     * @support  string $type 类型 
     * @support  string $name 试卷名称 
     * @support  array $group_ids 分组ids [Original type array&lt;int&gt;] 
     * @support  array $ids 试卷ids [Original type array&lt;int&gt;] 
     * @support  bool $has_learn_data 是否关联学习资料 
     * @support  bool $with_courses 是否包含关联课程信息 
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 通过ids获取试卷信息
     *
     * @support  array $ids_in ids 
     * @support  array $ids_not_in ids 
     * @support  string $category 试卷分类 
     * @support  string $type 类型 
     * @support  int $is_released 是否上线状态 
     * @support  int $staff_num 工号 [Original type uint] 
     * @support  string $name 试卷名称 
     * @support  bool $has_course 是否关联课程 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByIdsWithPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByIdsWithPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取试卷列表分页
     *
     * @support  string $category 试卷分类 
     * @support  array $categories 试卷分类组 
     * @support  int $is_released 是否上线 
     * @support  string $name 试卷名称 
     * @support  array $group_ids 分组ids [Original type array&lt;int&gt;] 
     * @support  int $staff_num 工号 
     * @support  string $type 题目类型 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 上线试卷
     *
     * @param  int $id 试卷id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function release (int $id) {
        return self::getClass()->release([
            "id" => $id,
        ]);
    }

    /**
     * 下线试卷
     *
     * @param  int $id 试卷id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unRelease (int $id) {
        return self::getClass()->unRelease([
            "id" => $id,
        ]);
    }

    /**
     * 更新试卷
     *
     * @param  int $id 试卷id [ require true ]
     * @support  string $category 分类名称 
     * @support  string $type 类型 
     * @support  array $can_rule 前置条件 
     * @support  string $name 试卷名称 
     * @support  int $time 限时(秒) 
     * @support  string $description 试卷描述 
     * @support  int $pass_score 通过分数 
     * @support  int $pass_credit 通过学分 
     * @support  array $question_config 题型配置 
     * @support  array $questions 题目 
     * @support  array $question_ids 题目ids [Original type array&lt;int&gt;] 
     * @support  int $courser_id 课程id 
     * @support  array $group_ids 分组ids [Original type array&lt;int&gt;] 
     * @support  array $extend 其他配置(随意) 
     * @support  array $score_item 评分项 
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateExam (int $id) {
        return self::getClass()->updateExam([
            "id" => $id,
        ]);
    }

    /**
     * 获取试卷分类
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCategories () {
        return self::getClass()->getCategories();
    }

    /**
     * 获取试卷类型
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getTypes () {
        return self::getClass()->getTypes();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'Exam');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'Exam');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}