<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method exchangeWishValueByParams(array $params)
 * @method getEventLogByParams(array $params)
 * @method getCreditChangeListByParams(array $params)
 * @method interactiveCreditIncreaseByParams(array $params)
 * @method creditIncreaseByParams(array $params)
 * @method getListByParams(array $params)
 */
class StaffArchive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 兑换愿望值
     *
     * @param  int $wish_value 愿望值 [Original type uint] [ require true ]
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exchangeWishValue (int $wish_value, int $staff_num, string $apply_in) {
        return self::getClass()->exchangeWishValue([
            "wish_value" => $wish_value,
            "staff_num" => $staff_num,
            "apply_in" => $apply_in,
        ]);
    }

    /**
     * 获取事件相关记录
     *
     * @support  array $event_name_array 事件名 [ require true ]
     * @support  string $created_at_start 创建时间起 
     * @support  string $created_at_end 创建时间止 
     * @support  array $ref_ids 对应id [Original type array&lt;uint&gt;] 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @support  bool $all 是否显示全部 
     * @throws  \Exception
     * @return  array
     */
    public static function getEventLog (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getEventLog([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 学分更改历史
     *
     * @support  array $event_name_array 事件名 
     * @support  string $created_at_start 创建时间起 
     * @support  string $created_at_end 创建时间止 
     * @support  int $staff_num 工号 [Original type uint] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @support  array $ref_ids 对应id [Original type array&lt;uint&gt;] 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @support  array $order_by 排序[[&#039;column&#039;, &#039;desc|asc&#039;]] 
     * @support  bool $all 是否显示全部 
     * @throws  \Exception
     * @return  array
     */
    public static function getCreditChangeList (string $apply_in = 'cloud', int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCreditChangeList([
            "apply_in" => $apply_in,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 增加互动积分
     *
     * @support  string $event_name 事件名 [ require true ]
     * @support  int $staff_num 工号 [Original type uint] [ require true ]
     * @support  int $credit 积分 [Original type uint] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @support  array $extend 拓展信息 
     * @support  int $ref_id 对应id [Original type uint] 
     * @support  bool $only_one 是否只增加一次 
     * @support  int $operator 操作人 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function interactiveCreditIncrease (string $apply_in = 'cloud') {
        return self::getClass()->interactiveCreditIncrease([
            "apply_in" => $apply_in,
        ]);
    }

    /**
     * 增加学分
     *
     * @support  string $event_name 事件名 [ require true ]
     * @support  int $staff_num 工号 [Original type uint] [ require true ]
     * @support  int $credit 积分 [Original type uint] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @support  array $extend 拓展信息 
     * @support  int $ref_id 对应id [Original type uint] 
     * @support  bool $only_one 是否只增加一次 
     * @support  int $operator 操作人 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function creditIncrease (string $apply_in = 'cloud') {
        return self::getClass()->creditIncrease([
            "apply_in" => $apply_in,
        ]);
    }

    /**
     * 档案列表
     *
     * @support  array $ids ids [Original type array&lt;uint&gt;] 
     * @param  array $staff_nums 员工号数组 [Original type array&lt;uint&gt;] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @support  bool $with_badge 勋章 
     * @support  bool $with_tags 标签 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @support  bool $all 是否显示全部 
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $page = 1, int $pageSize = 10, array $staff_nums = [], string $apply_in = 'cloud') {
        return self::getClass()->getList([
            "page" => $page,
            "pageSize" => $pageSize,
            "staff_nums" => $staff_nums,
            "apply_in" => $apply_in,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'StaffArchive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'StaffArchive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}