<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setTagByStaffNumByParams(array $params)
 * @method setTagByParams(array $params)
 * @method getTagByParams(array $params)
 */
class StaffArchiveTag {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * setTagByStaffNum
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $content 内容 [ require true ]
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setTagByStaffNum (int $staff_num, string $apply_in, string $name, string $content) {
        return self::getClass()->setTagByStaffNum([
            "staff_num" => $staff_num,
            "apply_in" => $apply_in,
            "name" => $name,
            "content" => $content,
        ]);
    }

    /**
     * setTag
     *
     * @support  string $name 名称 [ require true ]
     * @param  string $content 内容 [ require true ]
     * @param  int $archive_id 档案id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setTag (int $archive_id, string $content) {
        return self::getClass()->setTag([
            "archive_id" => $archive_id,
            "content" => $content,
        ]);
    }

    /**
     * getTag
     *
     * @support  string $name 名称 
     * @param  array $archive_ids 档案id [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTag (array $archive_ids) {
        return self::getClass()->getTag([
            "archive_ids" => $archive_ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'StaffArchiveTag');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'StaffArchiveTag');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}