<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method deleteByParams(array $params)
 */
class CourseCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取分类列表
     *
     * @support  array $ids 课程分类ids 
     * @param  string $name 分类名称(模糊查询) [ require true ]
     * @support  string $apply_in 应用于 
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  array
     */
    public static function getList (string $name = '') {
        return self::getClass()->getList([
            "name" => $name,
        ]);
    }

    /**
     * 获取分类列表分页
     *
     * @param  string $name 分类名称 [ require true ]
     * @support  string $apply_in 应用于 
     * @support  string $type 类型 
     * @param  bool $with_label 是否返回标签 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $pageSize = 10, string $name = '', bool $with_label = false) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "pageSize" => $pageSize,
            "name" => $name,
            "with_label" => $with_label,
        ]);
    }

    /**
     * 创建分类
     *
     * @param  string $name 分类名称 [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @support  array $label_ids 标签id [Original type array&lt;uint&gt;] 
     * @param  int $update_by 更新人员 [ require true ]
     * @support  array $extend 拓展信息 
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, string $apply_in, int $update_by) {
        return self::getClass()->create([
            "name" => $name,
            "apply_in" => $apply_in,
            "update_by" => $update_by,
        ]);
    }

    /**
     * 更新分类
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $name 分类名称 
     * @support  array $label_ids 标签id数组 [Original type array&lt;uint&gt;] 
     * @support  string $apply_in 应用于 
     * @param  int $update_by 更新人员 [ require true ]
     * @support  array $extend 拓展信息 
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, int $update_by) {
        return self::getClass()->update([
            "id" => $id,
            "update_by" => $update_by,
        ]);
    }

    /**
     * 获取分类详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 删除分类
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'CourseCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'CourseCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}