<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getDependenciesByParams(array $params)
 * @method delDependenciesByParams(array $params)
 */
class CanRules {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取对应的上下级依赖关系
     *
     * @param  array $owner_id 属主id数组 [ require true ]
     * @param  array $ref_id 关联id数组 [ require true ]
     * @param  string $owner_type 属主类型，即和owner_id对应 [ require true ]
     * @param  string $rule_type 关联类型，即和ref_id对应 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDependencies (array $owner_id = [], array $ref_id = [], string $owner_type = '', string $rule_type = '') {
        return self::getClass()->getDependencies([
            "owner_id" => $owner_id,
            "ref_id" => $ref_id,
            "owner_type" => $owner_type,
            "rule_type" => $rule_type,
        ]);
    }

    /**
     * 删除单个课程或考试的所有关联
     *
     * @param  int $id 属主id或关联id [ require true ]
     * @param  string $type 属主或关联id的类型 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function delDependencies (int $id, string $type) {
        return self::getClass()->delDependencies([
            "id" => $id,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'CanRules');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'CanRules');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}