<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method updateByParams(array $params)
 * @method reviewByParams(array $params)
 * @method getListByPageByParams(array $params)
 */
class Example {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  int $category_id 分类id [Original type uint] [ require true ]
     * @param  string $title 标题 [ require true ]
     * @param  string $origin 来源 [ require true ]
     * @param  string $content 详情 [ require true ]
     * @support  array $extend 拓展信息 
     * @param  int $create_by 创建人 [Original type uint] [ require true ]
     * @param  string $ding_instance_id 钉钉审批实例id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $category_id, string $title, string $origin, int $create_by, string $ding_instance_id, string $content = '') {
        return self::getClass()->create([
            "category_id" => $category_id,
            "title" => $title,
            "origin" => $origin,
            "create_by" => $create_by,
            "ding_instance_id" => $ding_instance_id,
            "content" => $content,
        ]);
    }

    /**
     * 获取当条详情
     *
     * @support  bool $with_review_log 包含审核信息 
     * @support  bool $with_category 包含分类信息 
     * @support  int $id 案例id [Original type uint] 
     * @support  string $ding_instance_id 审批实例id 
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo () {
        return self::getClass()->getInfo();
    }

    /**
     * 更新案例
     *
     * @support  int $id 案例id [Original type uint] 
     * @support  string $ding_instance_id 审批实例id 
     * @support  int $category_id 分类id [Original type uint] 
     * @support  string $title 标题 
     * @support  string $origin 来源 
     * @support  string $content 详情 
     * @support  array $extend 拓展信息 
     * @support  string $status 状态位 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 审核案例
     *
     * @support  int $id 案例id [Original type uint] 
     * @support  string $ding_instance_id 审批实例id 
     * @param  int $reviewer 审核人 [Original type uint] [ require true ]
     * @param  string $status 状态位 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function review (string $status, int $reviewer) {
        return self::getClass()->review([
            "status" => $status,
            "reviewer" => $reviewer,
        ]);
    }

    /**
     * 获取案例列表
     *
     * @support  array $ids 案例ids [Original type array&lt;uint&gt;] 
     * @support  array $category_ids 分类ids [Original type array&lt;uint&gt;] 
     * @support  string $title 标题模糊搜索 
     * @support  int $create_by 工号 [Original type uint] 
     * @support  bool $with_review_log 包含审核信息 
     * @support  string $created_at_start 创建时间起 
     * @support  string $created_at_end 创建时间止 
     * @support  string $status 状态位 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'Example');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'Example');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}