<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method deleteByParams(array $params)
 */
class CourseChildren {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建子课程
     *
     * @param  int $parent_id 主课程id [ require true ]
     * @support  string $description 描述 [ require true ]
     * @support  string $name 子课程名称 [ require true ]
     * @param  int $update_by 更新人员 [ require true ]
     * @support  array $can_rule 前置规则 
     * @param  array $learn_data 学习资料 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $parent_id, int $update_by, array $learn_data = []) {
        return self::getClass()->create([
            "parent_id" => $parent_id,
            "update_by" => $update_by,
            "learn_data" => $learn_data,
        ]);
    }

    /**
     * 修改子课程
     *
     * @param  int $id 子课程id [ require true ]
     * @support  string $description 描述 
     * @support  string $name 子课程名称 
     * @param  int $update_by 更新人员 [ require true ]
     * @support  array $can_rule 前置规则 
     * @support  array $learn_data 学习资料 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, int $update_by) {
        return self::getClass()->update([
            "id" => $id,
            "update_by" => $update_by,
        ]);
    }

    /**
     * 获取子课程详情
     *
     * @param  int $id 子课程id [ require true ]
     * @param  int $staff_num 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (int $id, int $staff_num = 0) {
        return self::getClass()->getInfo([
            "id" => $id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 删除子课程
     *
     * @param  int $id 子课程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'CourseChildren');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'CourseChildren');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}