<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getItemCountsByParams(array $params)
 * @method getStaffDateCountByParams(array $params)
 * @method getLearnCreditTopByParams(array $params)
 * @method CourseLearnPersonCountByParams(array $params)
 * @method everyDateCountByParams(array $params)
 * @method everyMonthCountByParams(array $params)
 */
class Count {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取统计值
     *
     * @param  string $item_name 统计项 [ require true ]
     * @support  array $item_keys 对应ids [Original type array&lt;uint&gt;] 
     * @throws  \Exception
     * @return  array
     */
    public static function getItemCounts (string $item_name) {
        return self::getClass()->getItemCounts([
            "item_name" => $item_name,
        ]);
    }

    /**
     * 获取员工时间线统计数量
     *
     * @support  int $staff_num 工号 [Original type uint] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @support  string $date_start 日期起 
     * @support  string $date_end 日期止 
     * @support  string $item_name 统计项 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffDateCount (string $apply_in = 'cloud') {
        return self::getClass()->getStaffDateCount([
            "apply_in" => $apply_in,
        ]);
    }

    /**
     * 获得排行信息
     *
     * @param  string $item_name 排行项 [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @support  int $staff_num 工号 [Original type uint] 
     * @support  string $date 日期 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 页码 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLearnCreditTop (string $item_name, string $apply_in = 'cloud', int $page = 1, int $page_size = 10) {
        return self::getClass()->getLearnCreditTop([
            "item_name" => $item_name,
            "apply_in" => $apply_in,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 定时更新学习人数
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function CourseLearnPersonCount () {
        return self::getClass()->CourseLearnPersonCount();
    }

    /**
     * 定时任务 统计每日学习信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function everyDateCount () {
        return self::getClass()->everyDateCount();
    }

    /**
     * 门店培训 定时任务 统计每月学习信息 排行榜
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function everyMonthCount () {
        return self::getClass()->everyMonthCount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'Count');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'Count');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}