<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method answerOneByParams(array $params)
 * @method submitByParams(array $params)
 * @method infoByParams(array $params)
 * @method reviewByParams(array $params)
 */
class Answer {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 只答一题
     *
     * @param  int $schedule_id 试卷任务id [ require true ]
     * @param  array $answer_info 回答信息组 [ require true ]
     * @param  int $staff_num 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function answerOne (int $schedule_id, array $answer_info, int $staff_num) {
        return self::getClass()->answerOne([
            "schedule_id" => $schedule_id,
            "answer_info" => $answer_info,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 提交回答
     *
     * @param  array $answer_info_arr 回答信息组 [ require true ]
     * @param  int $schedule_id 试卷任务id [ require true ]
     * @param  int $staff_num 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $schedule_id, int $staff_num, array $answer_info_arr = []) {
        return self::getClass()->submit([
            "schedule_id" => $schedule_id,
            "staff_num" => $staff_num,
            "answer_info_arr" => $answer_info_arr,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $schedule_id 试卷任务id [ require true ]
     * @param  int $staff_num 工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $schedule_id, int $staff_num) {
        return self::getClass()->info([
            "schedule_id" => $schedule_id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 评审
     *
     * @param  int $schedule_id 试卷任务id [ require true ]
     * @param  int $staff_num 工号 [ require true ]
     * @param  int $reviewer 评审人工号 [ require true ]
     * @param  array $review_info 评审信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function review (int $staff_num, int $schedule_id, array $review_info, int $reviewer) {
        return self::getClass()->review([
            "staff_num" => $staff_num,
            "schedule_id" => $schedule_id,
            "review_info" => $review_info,
            "reviewer" => $reviewer,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'Answer');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'Answer');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}