<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getInfoByParams(array $params)
 */
class Question {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建一个新的题目
     *
     * @param  string $name 问题名称 [ require true ]
     * @param  array $info 问题信息 [ require true ]
     * @param  string $type 问题类型 [ require true ]
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  int
     */
    public static function create (string $name, string $type, array $info = []) {
        return self::getClass()->create([
            "name" => $name,
            "type" => $type,
            "info" => $info,
        ]);
    }

    /**
     * 获取题目详情
     *
     * @param  int $id 问题id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'Question');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'Question');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}