<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateCourseLearnDataByParams(array $params)
 * @method getListByParams(array $params)
 * @method getCourseLearnDataByParams(array $params)
 */
class CourseLearnData {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * updateCourseLearnData
     *
     * @param  int $id 课程学习资料id [Original type uint] [ require true ]
     * @support  string $status 状态 
     * @support  array $content 内容 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateCourseLearnData (int $id) {
        return self::getClass()->updateCourseLearnData([
            "id" => $id,
        ]);
    }

    /**
     * getList
     *
     * @support  string $status 状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 获取一条
     *
     * @param  int $id 课程学习资料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCourseLearnData (int $id) {
        return self::getClass()->getCourseLearnData([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'CourseLearnData');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'CourseLearnData');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}