<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setStoreCourseDoneByParams(array $params)
 * @method getProgressAndCanByParams(array $params)
 * @method getNextCourseByExamByParams(array $params)
 * @method exitExamScheduleByParams(array $params)
 * @method beginExamByParams(array $params)
 * @method beginChildCourseByParams(array $params)
 * @method updateCourseLearnTimeByParams(array $params)
 * @method beginCourseByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method getListByParams(array $params)
 */
class Schedule {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置选修课完成 仅门店 并且无练习
     *
     * @param  int $schedule_id 进度id [Original type uint] [ require true ]
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStoreCourseDone (int $schedule_id, int $staff_num) {
        return self::getClass()->setStoreCourseDone([
            "schedule_id" => $schedule_id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 获取员工相关项进度
     *
     * @param  string $item_name 选项 [ require true ]
     * @param  array $ids id组 [Original type array&lt;uint&gt;] [ require true ]
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @param  array $group_ids 适用组 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProgressAndCan (string $item_name, array $ids, int $staff_num, array $group_ids = []) {
        return self::getClass()->getProgressAndCan([
            "item_name" => $item_name,
            "ids" => $ids,
            "staff_num" => $staff_num,
            "group_ids" => $group_ids,
        ]);
    }

    /**
     * getNextCourseByExam
     *
     * @param  int $exam_id 试卷id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNextCourseByExam (int $exam_id) {
        return self::getClass()->getNextCourseByExam([
            "exam_id" => $exam_id,
        ]);
    }

    /**
     * 退出考试(不计次数)
     *
     * @param  int $schedule_id 进度id [Original type uint] [ require true ]
     * @param  int $staff_num 员工工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exitExamSchedule (int $schedule_id, int $staff_num) {
        return self::getClass()->exitExamSchedule([
            "schedule_id" => $schedule_id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 开始答题|获取答题试卷(随试卷配置的题型产出)
     *
     * @param  int $exam_id 试卷id [ require true ]
     * @param  int $staff_num 员工工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function beginExam (int $exam_id, int $staff_num) {
        return self::getClass()->beginExam([
            "exam_id" => $exam_id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 开始主课程学习
     *
     * @param  int $child_course_id 子课程id [ require true ]
     * @param  int $staff_num 员工工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function beginChildCourse (int $child_course_id, int $staff_num) {
        return self::getClass()->beginChildCourse([
            "child_course_id" => $child_course_id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 更新主课程学习时长
     *
     * @param  int $course_id 主课程id [ require true ]
     * @param  int $staff_num 员工工号 [ require true ]
     * @param  int $append_time 新增学习时间 [ require true ]
     * @support  int $current_time 当前课程学习到时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateCourseLearnTime (int $course_id, int $staff_num, int $append_time) {
        return self::getClass()->updateCourseLearnTime([
            "course_id" => $course_id,
            "staff_num" => $staff_num,
            "append_time" => $append_time,
        ]);
    }

    /**
     * 开始主课程学习
     *
     * @param  int $course_id 主课程id [ require true ]
     * @param  int $staff_num 员工工号 [ require true ]
     * @param  array $group_ids 分组 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function beginCourse (int $course_id, int $staff_num, array $group_ids = []) {
        return self::getClass()->beginCourse([
            "course_id" => $course_id,
            "staff_num" => $staff_num,
            "group_ids" => $group_ids,
        ]);
    }

    /**
     * 学习进度列表分页
     *
     * @support  string $parent_type 任务父类型 
     * @support  array $staff_nums 员工工号s [Original type array&lt;int&gt;] 
     * @support  string $ref_type 任务类型 
     * @support  array $ref_ids 任务对应id [Original type array&lt;uint&gt;] 
     * @support  array $parent_ids 任务父ids [Original type array&lt;uint&gt;] 
     * @support  array $status 状态位 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 学习进度列表
     *
     * @support  array $staff_nums 员工工号s [Original type array&lt;int&gt;] 
     * @support  string $ref_type 任务类型 
     * @support  string $parent_type 任务父类型 
     * @support  array $status 状态位 
     * @support  array $ref_ids 任务对应ids [Original type array&lt;int&gt;] 
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'Schedule');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'Schedule');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}