<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffClickedByParams(array $params)
 * @method clickByParams(array $params)
 * @method unClickByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method topByParams(array $params)
 * @method createByParams(array $params)
 * @method unTopByParams(array $params)
 * @method deleteByParams(array $params)
 * @method managerDeleteByParams(array $params)
 */
class Comment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取员工已点赞留言
     *
     * @support  array $comment_ids 留言ids [Original type array&lt;uint&gt;] 
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffClicked (int $staff_num) {
        return self::getClass()->getStaffClicked([
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 赞
     *
     * @param  int $id 留言id [Original type uint] [ require true ]
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function click (int $staff_num, int $id) {
        return self::getClass()->click([
            "staff_num" => $staff_num,
            "id" => $id,
        ]);
    }

    /**
     * 取消赞
     *
     * @param  int $id 留言id [Original type uint] [ require true ]
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unClick (int $staff_num, int $id) {
        return self::getClass()->unClick([
            "staff_num" => $staff_num,
            "id" => $id,
        ]);
    }

    /**
     * 留言列表
     *
     * @support  int $course_id 课程id [Original type uint] 
     * @support  string $content 内容模糊匹配 
     * @support  array $course_ids 课程ids [Original type array&lt;uint&gt;] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取当条详情
     *
     * @param  int $id 留言id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 置顶
     *
     * @param  int $id 留言id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function top (int $id) {
        return self::getClass()->top([
            "id" => $id,
        ]);
    }

    /**
     * 留言
     *
     * @param  int $course_id 课程id [Original type uint] [ require true ]
     * @param  string $content 内容 [ require true ]
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function create (int $course_id, string $content, int $staff_num) {
        return self::getClass()->create([
            "course_id" => $course_id,
            "content" => $content,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 取消置顶
     *
     * @param  int $id 留言id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unTop (int $id) {
        return self::getClass()->unTop([
            "id" => $id,
        ]);
    }

    /**
     * 删除留言
     *
     * @param  int $id 留言id [Original type uint] [ require true ]
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id, int $staff_num) {
        return self::getClass()->delete([
            "id" => $id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 管理员删除
     *
     * @param  int $id 留言id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function managerDelete (int $id) {
        return self::getClass()->managerDelete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'Comment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'Comment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}