<?php
namespace Mainto\Bridge\Invokes\HimoTraining;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method cancelByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListByPageByParams(array $params)
 */
class Collection {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建
     *
     * @param  int $course_id 课程id [Original type uint] [ require true ]
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function create (int $course_id, int $staff_num) {
        return self::getClass()->create([
            "course_id" => $course_id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 取消收藏
     *
     * @param  int $id 收藏id [Original type uint] [ require true ]
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel (int $id, int $staff_num) {
        return self::getClass()->cancel([
            "id" => $id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $course_ids 课程ids [Original type array&lt;uint&gt;] 
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $staff_num) {
        return self::getClass()->getList([
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $course_ids 课程ids [Original type array&lt;uint&gt;] 
     * @param  int $staff_num 工号 [Original type uint] [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $staff_num, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListByPage([
            "staff_num" => $staff_num,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoTraining', 'Collection');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoTraining', 'Collection');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}