<?php
namespace Mainto\Bridge\Invokes\HimoThirdProxy\ThirdPartyOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method openRightByParams(array|\Mainto\Bridge\Structs\HimoThirdProxy\ThirdPartyOrder\Cmd\CMCCOrderCmd $params)
 * @method openCallbackByParams(array|\Mainto\Bridge\Structs\HimoThirdProxy\ThirdPartyOrder\Cmd\CMCCOpenRightMqCmd $params)
 */
class CMCCOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * CMCC 调用海马体，告知响应创建礼品卡的参数
     *
     * @var  \Mainto\Bridge\Structs\HimoThirdProxy\ThirdPartyOrder\Cmd\CMCCOrderCmd $orderCmd
     * @throws  \Exception
     * @return  string
     */
    public static function openRight (\Mainto\Bridge\Structs\HimoThirdProxy\ThirdPartyOrder\Cmd\CMCCOrderCmd $orderCmd) {
        return self::getClass()->openRight($orderCmd);
    }


    /**
     * 权益回调接口
     *
     * @var  \Mainto\Bridge\Structs\HimoThirdProxy\ThirdPartyOrder\Cmd\CMCCOpenRightMqCmd $orderCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function openCallback (\Mainto\Bridge\Structs\HimoThirdProxy\ThirdPartyOrder\Cmd\CMCCOpenRightMqCmd $orderCmd) {
        return self::getClass()->openCallback($orderCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoThirdProxy', 'ThirdPartyOrder\CMCCOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoThirdProxy', 'ThirdPartyOrder\CMCCOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}