<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByPageByParams(array $params)
 * @method operationByParams(array $params)
 * @method batchOperationByParams(array $params)
 * @method getInfoByIdByParams(array $params)
 * @method getSkuByListByParams(array $params)
 * @method getStockSkuByNameByParams(array $params)
 */
class PurchaseCountLimit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取分页数据
     *
     * @support  int $skuId sku_id require false
     * @support  int $storeId 门店id require false
     * @support  int $count 限制条数 require false
     * @support  int $createBy 操作人 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listByPage (int $page = 0, int $pageSize = 10) {
        return self::getClass()->listByPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 操作
     *
     * @support  int $skuId sku_id require false
     * @support  int $storeId 门店id require false
     * @support  int $count 限制条数 require false
     * @support  int $createBy 操作人 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function operation () {
        return self::getClass()->operation();
    }

    /**
     * 操作
     *
     * @support  int $createBy 操作人 [ require true ]
     * @support  array $data data [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchOperation () {
        return self::getClass()->batchOperation();
    }

    /**
     * 根据id获取详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfoById (int $id) {
        return self::getClass()->getInfoById([
            "id" => $id,
        ]);
    }

    /**
     * 获取列表中的sku
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuByList () {
        return self::getClass()->getSkuByList();
    }

    /**
     * 通过skuName 搜索
     *
     * @param  string $skuName skuName [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockSkuByName (string $skuName) {
        return self::getClass()->getStockSkuByName([
            "skuName" => $skuName,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseCountLimit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseCountLimit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}