<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSkuInfoByKeywordByParams(array $params)
 * @method getSkuInfoByIdsByParams(array $params)
 * @method getSkuListByParams(array $params)
 * @method getSkuListBySkuCodesByParams(array $params)
 * @method getSkuListByPageByParams(array $params)
 * @method editRetailMaterialByParams(array $params)
 * @method editRetailMaterialSkuByParams(array $params)
 * @method getMaterialSkusWithCategoryByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method firstByNameByParams(array $params)
 * @method createMaterialByParams(array $params)
 * @method updateMaterialByParams(array $params)
 * @method getMaterialIdsByParams(array $params)
 * @method getSkusByNameByParams(array $params)
 * @method findMaterialsByNameAndIsFixedAssetByParams(array $params)
 * @method getMaterialByNameByParams(array $params)
 * @method checkBatchMaterialByParams(array $params)
 * @method batchUpdateMaterialByParams(array $params)
 * @method getMaterialIdsByStoreTypesByParams(array $params)
 * @method getSkusByMaterialIdByParams(array $params)
 * @method materialFilteringByParams(array $params)
 * @method getMaterialWithSkusByParams(array $params)
 * @method bomListByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getMaterialWithSkusBySourcePageByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 * @method findMaterialByCodeByParams(array $params)
 * @method searchMaterialByPageByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取物料sku信息
     *
     * @param  int $source 物料来源 [ require true ]
     * @param  string $keyword 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuInfoByKeyword (int $source, string $keyword) {
        return self::getClass()->getSkuInfoByKeyword([
            "source" => $source,
            "keyword" => $keyword,
        ]);
    }

    /**
     * 根据物料skuId获取物料信息
     *
     * @support  array $skuIds 物料skuIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuInfoByIds () {
        return self::getClass()->getSkuInfoByIds();
    }

    /**
     * 根据条件获取物料信息
     *
     * @support  array $skuIds 物料skuIds require false
     * @support  int $source 物料来源 1是物料（自用）2 商品（零售） require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuList () {
        return self::getClass()->getSkuList();
    }

    /**
     * 根据条件获取物料信息
     *
     * @support  array $skuCodes 物料SkuCodes require false
     * @support  int $source 物料来源 1是物料（自用）2 商品（零售） require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuListBySkuCodes () {
        return self::getClass()->getSkuListBySkuCodes();
    }

    /**
     * 分页获取物料信息
     *
     * @support  array $skuIds 物料skuIds require false
     * @support  int $source 物料来源 1是物料（自用）2 商品（零售） require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuListByPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getSkuListByPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 同步零售产品到物料
     *
     * @param  array $data 物料信息 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRetailMaterial (array $data, int $operateId) {
        return self::getClass()->editRetailMaterial([
            "data" => $data,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 同步零售产品sku到物料sku
     *
     * @param  array $data 物料信息 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editRetailMaterialSku (array $data, int $operateId) {
        return self::getClass()->editRetailMaterialSku([
            "data" => $data,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 分页获取productSku表中商品信息，附带3级分类信息
     *
     * @support  int $source 物料来源 1是物料（自用）2 商品（零售） require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialSkusWithCategory (int $page, int $pageSize) {
        return self::getClass()->getMaterialSkusWithCategory([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 创建物料
     *
     * @param  int $createBy createBy [ require true ]
     * @support  string $name 名称 require false
     * @support  int $categoryId 分类id require false
     * @support  array $storeTypes 门店类型 require false
     * @support  int $brandId 品牌id require false
     * @support  string $deliveryType 发货方式 require false
     * @support  int $isStockTaking 是否盘点 require false
     * @support  int $isFixedAsset 是否资产 require false
     * @support  int $fixedAssetType 资产类型 require false
     * @support  array $skus sku信息 require false
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $createBy) {
        return self::getClass()->create([
            "createBy" => $createBy,
        ]);
    }

    /**
     * 更新物料
     *
     * @param  int $updateBy updateBy [ require true ]
     * @param  int $id 物料id [ require true ]
     * @support  string $name 名称 require false
     * @support  int $categoryId 分类id require false
     * @support  array $storeType 门店类型 require false
     * @support  int $brandId 品牌id require false
     * @support  string $deliveryType 发货方式 require false
     * @support  int $isStockTaking 是否盘点 require false
     * @support  int $isFixedAsset 是否资产 require false
     * @support  int $fixedAssetType 资产类型 require false
     * @support  array $skus sku信息 require false
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, int $updateBy) {
        return self::getClass()->update([
            "id" => $id,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 获取物料列表
     *
     * @support  string $name 名称 require false
     * @support  string $code code require false
     * @support  int $categoryId 分类id require false
     * @support  array $storeTypes 门店类型 require false
     * @support  int $supplierId 供应商id require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料详情
     *
     * @param  int $id 物料id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取物料详情
     *
     * @param  string $name 物料名称 [ require true ]
     * @param  int $source 物料平源 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function firstByName (string $name, int $source) {
        return self::getClass()->firstByName([
            "name" => $name,
            "source" => $source,
        ]);
    }

    /**
     * 创建物料
     *
     * @param  array $materials 物料 [ require true ]
     * @param  int $createBy 创建人 [ require true ]
     * @param  array $skus 物料SKU [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createMaterial (array $materials, int $createBy, array $skus) {
        return self::getClass()->createMaterial([
            "materials" => $materials,
            "createBy" => $createBy,
            "skus" => $skus,
        ]);
    }

    /**
     * 更新物料
     *
     * @param  int $id 物料id [ require true ]
     * @param  array $materials 物料 [ require true ]
     * @param  int $updateBy 更新者 [ require true ]
     * @param  array $skus skuid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateMaterial (int $id, array $materials, array $skus, int $updateBy) {
        return self::getClass()->updateMaterial([
            "id" => $id,
            "materials" => $materials,
            "skus" => $skus,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 通过物料ids得到物料
     *
     * @param  array $params 物料查询参数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialIds (array $params) {
        return self::getClass()->getMaterialIds([
            "params" => $params,
        ]);
    }

    /**
     * 得到物料基本信息
     *
     * @param  string $name 物料名称 [ require true ]
     * @param  int $source 物料来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByName (string $name, int $source) {
        return self::getClass()->getSkusByName([
            "name" => $name,
            "source" => $source,
        ]);
    }

    /**
     * 通过物料名和是否固定资产得到物料
     *
     * @param  string $name 物料名称 [ require true ]
     * @param  int $isFixedAsset 是否固定资产 [ require true ]
     * @param  int $source 物料来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function findMaterialsByNameAndIsFixedAsset (string $name, int $isFixedAsset = null, int $source = null) {
        return self::getClass()->findMaterialsByNameAndIsFixedAsset([
            "name" => $name,
            "isFixedAsset" => $isFixedAsset,
            "source" => $source,
        ]);
    }

    /**
     * 通过物料名得到物料
     *
     * @param  string $name 物料名称 [ require true ]
     * @param  array $source 物料来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialByName (string $name, array $source) {
        return self::getClass()->getMaterialByName([
            "name" => $name,
            "source" => $source,
        ]);
    }

    /**
     * 检验物料名和code是否存在
     *
     * @param  array $data 物料信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkBatchMaterial (array $data) {
        return self::getClass()->checkBatchMaterial([
            "data" => $data,
        ]);
    }

    /**
     * 批量更新物料
     *
     * @param  array $data 物料信息 [ require true ]
     * @param  int $updateBy 更新员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchUpdateMaterial (array $data, int $updateBy) {
        return self::getClass()->batchUpdateMaterial([
            "data" => $data,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 通过门店类型得到物料ids
     *
     * @param  array $storeTypes storetypes [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialIdsByStoreTypes (array $storeTypes) {
        return self::getClass()->getMaterialIdsByStoreTypes([
            "storeTypes" => $storeTypes,
        ]);
    }

    /**
     * 通过materialId得到物料sku
     *
     * @param  int $id 物料id [ require true ]
     * @param  int $status 状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByMaterialId (int $id, int $status) {
        return self::getClass()->getSkusByMaterialId([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * 通过materialId得到物料sku
     *
     * @param  int $storeTypeMaterialIds 物料id [ require true ]
     * @param  int $status 状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function materialFiltering (int $storeTypeMaterialIds, int $status) {
        return self::getClass()->materialFiltering([
            "storeTypeMaterialIds" => $storeTypeMaterialIds,
            "status" => $status,
        ]);
    }

    /**
     * 得到物料和其sku
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialWithSkus () {
        return self::getClass()->getMaterialWithSkus();
    }

    /**
     * 得到bom列表
     *
     * @param  array $params 物料id [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 页数 [ require true ]
     * @param  array $materialIds 物料ids [ require true ]
     * @param  array $storeTypeMaterialIds storeType物料ids [ require true ]
     * @param  array $bomSkuIds bomskuIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bomList (array $params, int $page, int $pageSize, array $materialIds = [], array $storeTypeMaterialIds = [], array $bomSkuIds = null) {
        return self::getClass()->bomList([
            "params" => $params,
            "page" => $page,
            "pageSize" => $pageSize,
            "materialIds" => $materialIds,
            "storeTypeMaterialIds" => $storeTypeMaterialIds,
            "bomSkuIds" => $bomSkuIds,
        ]);
    }

    /**
     * 通过各种条件获取materialIds
     *
     * @support  array $ids ids require false
     * @support  int $source 物料来源 require false
     * @support  int $isStockTaking 是否盘点 require false
     * @support  int $isFixedAsset 是否固定资产 require false
     * @support  array $fileds 获取字段 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo () {
        return self::getClass()->getInfo();
    }

    /**
     * 通过source获取物料及sku
     *
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 页数 [ require true ]
     * @param  int $source 物料来源 1是物料（自用）2 商品（零售） [ require true ]
     * @param  array $params 物料名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialWithSkusBySourcePage (int $source, int $page, int $pageSize, array $params = []) {
        return self::getClass()->getMaterialWithSkusBySourcePage([
            "source" => $source,
            "page" => $page,
            "pageSize" => $pageSize,
            "params" => $params,
        ]);
    }

    /**
     * 钉钉审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function callbackDingProcess () {
        return self::getClass()->callbackDingProcess();
    }

    /**
     * 根据条件修改sku（非价格字段）
     *
     * @param  string $code skuCode [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function findMaterialByCode (string $code) {
        return self::getClass()->findMaterialByCode([
            "code" => $code,
        ]);
    }

    /**
     * 根据条件修改sku（非价格字段）
     *
     * @support  array $materialIds 物料ids require false
     * @support  string $deliveryType 物料所以类型 require false
     * @support  int $supplierId 供应商id require false
     * @support  array $categoryIds 分类ids require false
     * @support  string $name 物料名称 require false
     * @support  string $status sku状态 require false
     * @support  int $isFixedAsset 是否固定资产 [ require true ]
     * @support  int $page 分码 [ require true ]
     * @support  int $pageSize 条数 [ require true ]
     * @support  int $source 物料source require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchMaterialByPage () {
        return self::getClass()->searchMaterialByPage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}