<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setStockOutNameByParams(array $params)
 * @method setStockInNameByParams(array $params)
 * @method stockFlowListByParams(array $params)
 * @method stockFlowItemListByParams(array $params)
 * @method stockFlowDetailByParams(array $params)
 * @method stockListByParams(array $params)
 * @method materialStockListByParams(array $params)
 * @method stockListBySkuIdsByParams(array $params)
 * @method getStockSkuByKeywordByParams(array $params)
 * @method stockInsideMoveByParams(array $params)
 * @method stockOtherOutByParams(array $params)
 * @method saleChangeStockByParams(array $params)
 * @method stockInitializeByParams(array $params)
 * @method initializeStockByParams(array $params)
 * @method storageStockByParams(array $params)
 * @method storageStockBySkuIdByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置出库单随机数key(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStockOutName () {
        return self::getClass()->setStockOutName();
    }

    /**
     * 设置入库单随机数key(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStockInName () {
        return self::getClass()->setStockInName();
    }

    /**
     * 出入库记录列表
     *
     * @support  int $storageId 收货仓库id require false
     * @support  string $documentType 单据类型 require false
     * @support  string $associateDocumentNo 上级单据编号 require false
     * @support  string $createAtBegin 创建开始时间 require false
     * @support  string $createAtEnd 创建结束时间 require false
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockFlowList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->stockFlowList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 出入库记录明细列表
     *
     * @support  int $storageId 收货仓库id require false
     * @support  int $skuId skuId require false
     * @support  int $stockFlowId 出入库记录明细主表id require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockFlowItemList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->stockFlowItemList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 出入库记录详情
     *
     * @param  int $id 出入库详情id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockFlowDetail (int $id) {
        return self::getClass()->stockFlowDetail([
            "id" => $id,
        ]);
    }

    /**
     * 库存列表--仓库视角
     *
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 require false
     * @support  int $storageId 仓库id require false
     * @support  string $skuName sku名称 require false
     * @support  string $skuCode SKU编码 require false
     * @support  string $barcode 条形码 require false
     * @support  int $isFixedAsset 是否是固定资产 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->stockList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 库存列表--商品视角
     *
     * @support  int $source 物料来源 1是物料（自用）2 商品（零售） [ require true ]
     * @support  string $skuName sku名称 require false
     * @support  string $skuCode SKU编码 require false
     * @support  string $barcode 条形码 require false
     * @support  int $isFixedAsset 是否是固定资产 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function materialStockList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->materialStockList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据仓库id获取对应skuIds的库存
     *
     * @param  int $storageId 仓库id [ require true ]
     * @param  array $skuIds sku列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockListBySkuIds (int $storageId, array $skuIds) {
        return self::getClass()->stockListBySkuIds([
            "storageId" => $storageId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 获取仓库物料sku信息
     *
     * @param  int $storageId 仓库id [ require true ]
     * @param  int $source 物料来源 [ require true ]
     * @param  string $keyword 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockSkuByKeyword (int $source, int $storageId, string $keyword) {
        return self::getClass()->getStockSkuByKeyword([
            "source" => $source,
            "storageId" => $storageId,
            "keyword" => $keyword,
        ]);
    }

    /**
     * 仓内库存转移
     *
     * @support  int $storageId 调整仓库id [ require true ]
     * @support  string $fromCount 仓内调出库存类型：正品sale_usable_count 样品sample_usable_count 残次defective_count [ require true ]
     * @support  string $toCount 仓内调入库存类型：正品sale_usable_count 样品sample_usable_count 残次defective_count [ require true ]
     * @support  array $itemList 调整sku列表 [ require true ]
     * @support  string $remark 备注 require false
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockInsideMove (int $operateId) {
        return self::getClass()->stockInsideMove([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 其他出库
     *
     * @support  int $storageId 调整仓库id [ require true ]
     * @support  string $fromType 出库存类型：正品sale_usable_count 样品sample_usable_count 残次defective_count [ require true ]
     * @support  array $itemList 调整sku列表 [ require true ]
     * @support  int $memberId 自用物料领用人 require false
     * @support  string $receiver 其他出库收货人 require false
     * @support  string $remark 备注 require false
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockOtherOut (int $operateId) {
        return self::getClass()->stockOtherOut([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 变更库存，目前只用于销售出库、退货入库
     *
     * @support  int $storageId 调整仓库id [ require true ]
     * @support  array $itemList 调整sku列表 [ require true ]
     * @support  string $documentType 库存调整类型xsck,thrk [ require true ]
     * @support  int $associateDocumentId 关联单据id [ require true ]
     * @support  string $associateDocumentNo 关联单据编号 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saleChangeStock (int $operateId) {
        return self::getClass()->saleChangeStock([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 库存初始化
     *
     * @support  int $storageId 调整仓库id [ require true ]
     * @support  array $itemList 调整sku列表 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @support  string $remark 备注 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockInitialize (int $operateId) {
        return self::getClass()->stockInitialize([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 用于补漏的物料库存初始化
     *
     * @support  int $storageId 调整仓库id [ require true ]
     * @support  array $itemList 调整sku列表 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function initializeStock (int $operateId) {
        return self::getClass()->initializeStock([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取仓库里的skuids,可指定sku_id
     *
     * @support  int $storageId 仓库id require false
     * @support  array $skuids skuids require false
     * @support  int $isStockTaking 是否需要盘点 require false
     * @support  int $isFixedAsset 是否固定资产 require false
     * @throws  \Exception
     * @return  array
     */
    public static function storageStock () {
        return self::getClass()->storageStock();
    }

    /**
     * 获取仓库里的skuid的库存信息
     *
     * @support  int $storageId 仓库id require false
     * @support  array $skuids skuids require false
     * @throws  \Exception
     * @return  array
     */
    public static function storageStockBySkuId () {
        return self::getClass()->storageStockBySkuId();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}