<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setInventoryMissionNumberByParams(array $params)
 * @method setInventoryNumberByParams(array $params)
 * @method generateMidMonthMissionByParams(array $params)
 * @method generateEndOfMonthMissionByParams(array $params)
 * @method missionListByParams(array $params)
 * @method missionDetailByParams(array $params)
 * @method storeInMissionByParams(array $params)
 * @method skuInMissionByParams(array $params)
 * @method missionCreateByParams(array $params)
 * @method missionRevokeByParams(array $params)
 * @method missionProcessByParams(array $params)
 * @method missionProcessRateByParams(array $params)
 * @method listByParams(array $params)
 * @method resultByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method saveByParams(array $params)
 * @method checkApproveStatusByParams(array $params)
 * @method approveByParams(array $params)
 * @method approveReturnByParams(array $params)
 * @method approveRevokeByParams(array $params)
 * @method noticeByParams(array $params)
 * @method differenceByParams(array $params)
 * @method getAllItemsByInventoryIdByParams(array $params)
 * @method getInventoryItemsSortByCategoryByParams(array $params)
 * @method getSkuidsSortByCategoryByParams(array $params)
 * @method recheckByParams(array $params)
 * @method missionsDetailByParams(array $params)
 */
class Inventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置盘点任务单号
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setInventoryMissionNumber () {
        return self::getClass()->setInventoryMissionNumber();
    }

    /**
     * 设置盘点单号
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setInventoryNumber () {
        return self::getClass()->setInventoryNumber();
    }

    /**
     * 月中自动创建任务
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function generateMidMonthMission () {
        return self::getClass()->generateMidMonthMission();
    }

    /**
     * 月底自动创建任务
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function generateEndOfMonthMission () {
        return self::getClass()->generateEndOfMonthMission();
    }

    /**
     * 盘点任务列表
     *
     * @support  string $missionNo 任务单号 require false
     * @support  string $createStart 创建时间开始 require false
     * @support  string $createEnd 创建时间结束 require false
     * @support  string $inventoryStart 盘点日期开始 require false
     * @support  string $inventoryEnd 盘点日期结束 require false
     * @support  string $orderType 盘点来源类型 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function missionList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->missionList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点任务详情
     *
     * @param  int $missionId 任务ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function missionDetail (int $missionId) {
        return self::getClass()->missionDetail([
            "missionId" => $missionId,
        ]);
    }

    /**
     * 盘点任务关联门店
     *
     * @param  int $missionId 任务ID [ require true ]
     * @support  int $storeId 门店id require false
     * @support  string $status 审核状态 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeInMission (int $missionId) {
        return self::getClass()->storeInMission([
            "missionId" => $missionId,
        ]);
    }

    /**
     * 盘点任务关联SKU
     *
     * @param  int $missionId 任务ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function skuInMission (int $missionId) {
        return self::getClass()->skuInMission([
            "missionId" => $missionId,
        ]);
    }

    /**
     * 新增盘点任务
     *
     * @support  string $inventoryStart 盘点日期开始 require false
     * @support  string $inventoryEnd 盘点日期结束 require false
     * @support  string $remark 备注 require false
     * @support  int $allSku 是否所有商品 require false
     * @support  int $allStore 是否所有门店 require false
     * @support  array $storeIds 盘点门店ID数组 [ require true ]
     * @support  array $skuIds 盘点商品ID数组 require false
     * @support  int $createBy 创建人 [ require true ]
     * @support  string $orderType 订单类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function missionCreate () {
        return self::getClass()->missionCreate();
    }

    /**
     * 盘点任务撤回
     *
     * @param  int $missionId 任务ID [ require true ]
     * @param  int $updateBy 修改人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function missionRevoke (int $missionId, int $updateBy) {
        return self::getClass()->missionRevoke([
            "missionId" => $missionId,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 盘点进度
     *
     * @support  int $missionId 任务ID [ require true ]
     * @support  int $storeId 门店ID require false
     * @support  string $status 状态 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function missionProcess (int $page = 1, int $pageSize = 10) {
        return self::getClass()->missionProcess([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点进度计算
     *
     * @param  int $missionId 任务ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function missionProcessRate (int $missionId) {
        return self::getClass()->missionProcessRate([
            "missionId" => $missionId,
        ]);
    }

    /**
     * 门店盘点列表
     *
     * @support  string $inventoryStart 盘点日期开始 require false
     * @support  string $inventoryEnd 盘点日期结束 require false
     * @support  string $inventoryType 盘点发起类型|总部or自发 require false
     * @support  string $approveStatus 审核状态 require false
     * @support  string $orderType 盘点物料类型|自用or零售 require false
     * @support  int $storeId 门店ID [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点结果
     *
     * @support  string $inventoryStart 盘点日期开始 require false
     * @support  string $inventoryEnd 盘点日期结束 require false
     * @support  int $storeId 门店ID require false
     * @support  int $isDifferent 有无差异 require false
     * @support  string $approveStatus 审核状态 require false
     * @param  string $orderType 盘点类型 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function result (string $orderType, int $page = 1, int $pageSize = 10) {
        return self::getClass()->result([
            "orderType" => $orderType,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点详情
     *
     * @param  int $inventoryId 盘点ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $inventoryId) {
        return self::getClass()->detail([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 盘点明细
     *
     * @param  int $inventoryId 盘点ID [ require true ]
     * @param  bool $adjust 仅调整 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $inventoryId, int $page = 1, int $pageSize = 10, bool $adjust = false) {
        return self::getClass()->itemList([
            "inventoryId" => $inventoryId,
            "page" => $page,
            "pageSize" => $pageSize,
            "adjust" => $adjust,
        ]);
    }

    /**
     * 新增盘点
     *
     * @support  int $inventoryId 盘点ID require false
     * @support  int $createBy 创建人 [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @support  string $orderType 盘点订单类型 require false
     * @support  int $isAutoApprove 是否自动通过，零售为自动通过 require false
     * @support  string $inventoryType 盘点类型 require false
     * @support  array $skuInfos 盘点商品数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function save () {
        return self::getClass()->save();
    }

    /**
     * 验证审核状态
     *
     * @support  array $inventoryIds 盘点IDs [ require true ]
     * @support  string $approveStatus 审批状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkApproveStatus () {
        return self::getClass()->checkApproveStatus();
    }

    /**
     * 盘点审批通过
     *
     * @param  array $inventoryIds 盘点IDs [ require true ]
     * @param  int $approveBy 审核人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function approve (array $inventoryIds, int $approveBy) {
        return self::getClass()->approve([
            "inventoryIds" => $inventoryIds,
            "approveBy" => $approveBy,
        ]);
    }

    /**
     * 盘点审批驳回
     *
     * @param  array $inventoryIds 盘点IDs [ require true ]
     * @param  int $approveBy 审核人 [ require true ]
     * @param  string $remark 驳回备注 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function approveReturn (array $inventoryIds, int $approveBy, string $remark) {
        return self::getClass()->approveReturn([
            "inventoryIds" => $inventoryIds,
            "approveBy" => $approveBy,
            "remark" => $remark,
        ]);
    }

    /**
     * 驳回审核 撤回
     *
     * @param  array $inventoryIds 盘点IDs [ require true ]
     * @param  int $approveBy 审核人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function approveRevoke (array $inventoryIds, int $approveBy) {
        return self::getClass()->approveRevoke([
            "inventoryIds" => $inventoryIds,
            "approveBy" => $approveBy,
        ]);
    }

    /**
     * 盘点提醒
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function notice (int $storeId) {
        return self::getClass()->notice([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 盘点差异
     *
     * @support  string $approveStart 调整日期开始 require false
     * @support  string $approveEnd 调整日期结束 require false
     * @support  int $storeId 门店ID require false
     * @support  string $orderType 盘点订单类型 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function difference (int $page = 1, int $pageSize = 10) {
        return self::getClass()->difference([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取指定盘点ID的所有item信息
     *
     * @support  int $inventoryId 盘点ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllItemsByInventoryId () {
        return self::getClass()->getAllItemsByInventoryId();
    }

    /**
     * 分类排序返回盘点数据
     *
     * @support  int $inventoryId inventoryId [ require true ]
     * @support  int $page page require false
     * @support  int $pageSize pageSize require false
     * @support  bool $isPaginate 是否分页 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getInventoryItemsSortByCategory () {
        return self::getClass()->getInventoryItemsSortByCategory();
    }

    /**
     * 分类排序返回skuids数据
     *
     * @support  array $skuids skuids [ require true ]
     * @support  int $page page require false
     * @support  int $pageSize pageSize require false
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuidsSortByCategory () {
        return self::getClass()->getSkuidsSortByCategory();
    }

    /**
     * 被驳回后提交盘点结果
     *
     * @support  int $inventoryId 盘点ID [ require true ]
     * @support  array $skuInfos 盘点商品数组 [ require true ]
     * @support  string $submit_remark 盘点提交说明 require false
     * @support  string $refuse_remark 盘点驳回说明 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function recheck () {
        return self::getClass()->recheck();
    }

    /**
     * 获取指定盘点任务ids的详情
     *
     * @support  array $missionIds 任务IDs require false
     * @throws  \Exception
     * @return  array
     */
    public static function missionsDetail () {
        return self::getClass()->missionsDetail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Inventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Inventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}