<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListPageByParams(array $params)
 * @method getAccountListByParams(array $params)
 * @method editSupplierInfoByParams(array $params)
 * @method createAccountByParams(array $params)
 * @method delAccountByParams(array $params)
 * @method getSuppliersByParams(array $params)
 * @method findOrFailByIdByParams(array $params)
 * @method syncSupplierByParams(array $params)
 * @method getSuppliersByIdsByParams(array $params)
 * @method syncJdSupplierByParams(array $params)
 * @method searchSupplierAccountByParams(array $params)
 */
class Supplier {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取供应商分页列表
     *
     * @support  int $id 供应商id [ require false ]
     * @support  int $status 是否开启协同 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListPage (int $page = 1, int $pageSize = 15) {
        return self::getClass()->getListPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取供应商 下的全部协同平台账号
     *
     * @param  int $supplierId 供应商id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAccountList (int $supplierId) {
        return self::getClass()->getAccountList([
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * 修改供应商信息
     *
     * @param  int $supplierId 供应商id [ require true ]
     * @support  string $status 是否开启协同 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editSupplierInfo (int $supplierId) {
        return self::getClass()->editSupplierInfo([
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * 创建供应商系统平台账号
     *
     * @support  int $supplierId 供应商id [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  string $nickName 昵称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAccount () {
        return self::getClass()->createAccount([
        ]);
    }

    /**
     * 删除供应商账号
     *
     * @support  int $id 协同平台账号id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delAccount () {
        return self::getClass()->delAccount([
        ]);
    }

    /**
     * 通过名字或者供应商id得到供应商
     *
     * @support  string $name 供应商名字 [ require false ]
     * @support  array $supplierIds 供应商ids [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSuppliers () {
        return self::getClass()->getSuppliers([
        ]);
    }

    /**
     * 通过供应商id得到供应商
     *
     * @support  int $supplierId 供应商id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function findOrFailById () {
        return self::getClass()->findOrFailById([
        ]);
    }

    /**
     * W
     *
     * @support  string $name 供应商名称 [ require false ]
     * @support  int $nsId nsId [ require false ]
     * @support  float $prepaidRate 税率 [ require false ]
     * @support  array $extend 额外信息 [ require false ]
     * @support  array $details 银行信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncSupplier () {
        return self::getClass()->syncSupplier([
        ]);
    }

    /**
     * 通过供应商id得到供应商s
     *
     * @param  array $ids 供应商ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSuppliersByIds (array $ids) {
        return self::getClass()->getSuppliersByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 同步金蝶供应商
     *
     * @support  string $name 供应商名称 [ require false ]
     * @support  int $jdId jdId [ require false ]
     * @support  float $prepaidRate 税率 [ require false ]
     * @support  array $extend 额外信息 [ require false ]
     * @support  array $details 银行信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncJdSupplier () {
        return self::getClass()->syncJdSupplier([
        ]);
    }

    /**
     * 供应商账户查询
     *
     * @support  string $phone 手机号 [ require false ]
     * @support  int $supplyId 供应商id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchSupplierAccount () {
        return self::getClass()->searchSupplierAccount([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Supplier');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Supplier');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}