<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method itemListByParams(array $params)
 * @method importByParams(array $params)
 * @method importTrackingNumberByParams(array $params)
 * @method batchSendByParams(array $params)
 * @method processByParams(array $params)
 * @method sendByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method getItemsByOrderItemIdsByParams(array $params)
 * @method getItemsByDemandItemIdsByParams(array $params)
 * @method getItemsByItemIdsByParams(array $params)
 * @method getByIdsByParams(array $params)
 * @method getItemsByStatusAndNoticeIdsByParams(array $params)
 * @method updateShipNoticeBomByParams(array $params)
 * @method productItemListByParams(array $params)
 * @method getItemsByNoticeIdsByParams(array $params)
 * @method trySyncReceiveToWmsByParams(array $params)
 * @method updateShipByParams(array $params)
 * @method searchShipNoticeByParams(array $params)
 * @method changePlanShipDateByParams(array $params)
 * @method checkBmsShipByParams(array $params)
 * @method checkBmsNoticeItemIdsByParams(array $params)
 * @method supplySystemBatchSendByParams(array $params)
 * @method getRedPointCountByStorageIdByParams(array $params)
 * @method getShopCountByStorageIdByParams(array $params)
 */
class PurchaseShipNotice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $noticeNo 发货通知单号 [ require false ]
     * @support  string $orderNo 采购单号 [ require false ]
     * @support  string $createdAtStart 创建开始时间 [ require false ]
     * @support  string $createdAtEnd 创建结束时间 [ require false ]
     * @support  int $createBy 创建人工号 [ require false ]
     * @support  int $shipBy 发货方 [ require false ]
     * @support  array $status 状态 [ require false ]
     * @support  int $source 来源2成品3原料 [ require false ]
     * @support  string $demandNo 需求单号 [ require false ]
     * @support  array $skuIds sku ids [ require false ]
     * @support  string $receiveNo 收货单号 [ require false ]
     * @support  int $fromStorageId 发货方id [ require false ]
     * @support  int $toStorageId 收货方id [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @support  int $noticeId 发货通知单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 零售采购的发货修改
     *
     * @param  int $updateBy 操作人工号 [ require true ]
     * @param  int $noticeId 发货通知单id [ require true ]
     * @param  string $planDate 预计到货时间 [ require true ]
     * @param  string $trackingNumber 物流单号 [ require true ]
     * @param  int $expressTypeId 物流类别单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $updateBy, int $noticeId, string $planDate, string $trackingNumber, int $expressTypeId) {
        return self::getClass()->update([
            "updateBy" => $updateBy,
            "noticeId" => $noticeId,
            "planDate" => $planDate,
            "trackingNumber" => $trackingNumber,
            "expressTypeId" => $expressTypeId,
        ]);
    }

    /**
     * 明细列表
     *
     * @support  int $noticeId 采购单id [ require false ]
     * @support  array $shipNoticeIds 主单ids [ require false ]
     * @support  string $timeStatus 时间状态 [ require false ]
     * @support  array $status 发货状态 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList () {
        return self::getClass()->itemList([
        ]);
    }

    /**
     * 导入快递单号和数量
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function import (int $updateBy, array $data) {
        return self::getClass()->import([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 导入快递单号
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importTrackingNumber (int $updateBy, array $data) {
        return self::getClass()->importTrackingNumber([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 批量发运
     *
     * @param  int $createBy 更新人工号 [ require true ]
     * @support  int $updateBySupplyId 更新人工号 [ require false ]
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @param  int $source 发货通知单source [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchSend (int $createBy, array $noticeIds, int $source = 0) {
        return self::getClass()->batchSend([
            "createBy" => $createBy,
            "noticeIds" => $noticeIds,
            "source" => $source,
        ]);
    }

    /**
     * 成品加工
     *
     * @param  int $createBy 更新人工号 [ require true ]
     * @param  int $noticeId 发货通知单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function process (int $createBy, int $noticeId) {
        return self::getClass()->process([
            "createBy" => $createBy,
            "noticeId" => $noticeId,
        ]);
    }

    /**
     * 发运
     *
     * @param  int $createBy 更新人工号 [ require true ]
     * @param  int $noticeId 发货通知单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function send (int $createBy, int $noticeId) {
        return self::getClass()->send([
            "createBy" => $createBy,
            "noticeId" => $noticeId,
        ]);
    }

    /**
     * 批量更新
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  array $data 待修改的信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUpdate (int $updateBy, array $data) {
        return self::getClass()->batchUpdate([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 批量关闭
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  array $data 待关闭的信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchClose (int $updateBy, array $data) {
        return self::getClass()->batchClose([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 根据订单明细ids获取发货明细信息
     *
     * @param  array $orderItemIds 采购单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByOrderItemIds (array $orderItemIds) {
        return self::getClass()->getItemsByOrderItemIds([
            "orderItemIds" => $orderItemIds,
        ]);
    }

    /**
     * 根据订单明细ids获取发货明细信息
     *
     * @param  array $demandItemIds 采购单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByDemandItemIds (array $demandItemIds) {
        return self::getClass()->getItemsByDemandItemIds([
            "demandItemIds" => $demandItemIds,
        ]);
    }

    /**
     * 根据订单明细ids获取发货明细信息
     *
     * @param  array $itemIds 采购单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByItemIds (array $itemIds) {
        return self::getClass()->getItemsByItemIds([
            "itemIds" => $itemIds,
        ]);
    }

    /**
     * 根据发货ids获取发货信息
     *
     * @param  array $ids 通知单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getByIds (array $ids) {
        return self::getClass()->getByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 根据发货ids获取发货信息
     *
     * @param  array $status status [ require true ]
     * @param  array $noticeIds noticeIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByStatusAndNoticeIds (array $status, array $noticeIds) {
        return self::getClass()->getItemsByStatusAndNoticeIds([
            "status" => $status,
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 修改成品bom记录
     *
     * @param  int $itemId itemId [ require true ]
     * @param  int $createBy createBy [ require true ]
     * @param  array $data data [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateShipNoticeBom (int $itemId, int $createBy, array $data) {
        return self::getClass()->updateShipNoticeBom([
            "itemId" => $itemId,
            "createBy" => $createBy,
            "data" => $data,
        ]);
    }

    /**
     * 成品发货明细列表
     *
     * @param  int $noticeId 采购单id [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function productItemList (int $noticeId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->productItemList([
            "noticeId" => $noticeId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据发货单IDs获取明细
     *
     * @param  array $noticeIds 发货通知单IDs [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByNoticeIds (array $noticeIds) {
        return self::getClass()->getItemsByNoticeIds([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 重试 推送ebs失败收货单
     *
     * @param  array $receiveIds 收货单ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function trySyncReceiveToWms (array $receiveIds) {
        return self::getClass()->trySyncReceiveToWms([
            "receiveIds" => $receiveIds,
        ]);
    }

    /**
     * id
     *
     * @support  int $id id [ require false ]
     * @support  int $createBy createBy [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateShip () {
        return self::getClass()->updateShip([
        ]);
    }

    /**
     * 查询发货通知单
     *
     * @support  int $fromStorageId 发货仓 [ require false ]
     * @support  array $status 发货通知单状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchShipNotice () {
        return self::getClass()->searchShipNotice([
        ]);
    }

    /**
     * 加急发货通知单
     *
     * @param  array $noticeIds 发货通知单id [ require true ]
     * @param  int $expedited 是否加急 [ require true ]
     * @param  string $planShipDate 预计发货时间 [ require true ]
     * @param  string $planLastShipDate 最晚发货时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changePlanShipDate (array $noticeIds, int $expedited, string $planShipDate, string $planLastShipDate) {
        return self::getClass()->changePlanShipDate([
            "noticeIds" => $noticeIds,
            "expedited" => $expedited,
            "planShipDate" => $planShipDate,
            "planLastShipDate" => $planLastShipDate,
        ]);
    }

    /**
     * checkBmsShip
     *
     * @support  array $noticeIds 发货通知单ids [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkBmsShip () {
        return self::getClass()->checkBmsShip([
        ]);
    }

    /**
     * checkBmsNoticeItemIds
     *
     * @support  array $noticeItemIds 发货通知单子单ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkBmsNoticeItemIds () {
        return self::getClass()->checkBmsNoticeItemIds([
        ]);
    }

    /**
     * 供应商协同批量发运,不合单。一个主单对应一个子单
     *
     * @support  array $items 发货仓 [ require false ]
     * @support  mixed $item  [ require false ]
     * @support  int $updateBySupplyId 发货人 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function supplySystemBatchSend () {
        return self::getClass()->supplySystemBatchSend([
        ]);
    }

    /**
     * 获取同一个发货通知单仓库下红点数量
     *
     * @param  int $storageId 仓库id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getRedPointCountByStorageId (int $storageId) {
        return self::getClass()->getRedPointCountByStorageId([
            "storageId" => $storageId,
        ]);
    }

    /**
     * 获取同一个发货通知单仓库下门店数
     *
     * @param  int $storageId 仓库id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getShopCountByStorageId (int $storageId) {
        return self::getClass()->getShopCountByStorageId([
            "storageId" => $storageId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseShipNotice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseShipNotice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}