<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createRetailUnsaleByParams(array $params)
 * @method cancelRetailUnsaleByParams(array $params)
 * @method getListByParams(array $params)
 * @method searchRetailUnsaleByParams(array $params)
 * @method getDetailByParams(array $params)
 * @method pushToGwallByParams(array $params)
 */
class PurchaseRetailUnsale {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售领用单
     *
     * @support  int $applyId 申请人id [ require true ]
     * @support  int $applyDepartmentId 申请部门 [ require true ]
     * @support  int $source 1自用,2零售商品,3零售原料 [ require true ]
     * @support  int $fromStorageId 出仓库 [ require true ]
     * @support  string $reason 申请原因 [ require false ]
     * @support  string $name 姓名 [ require true ]
     * @support  string $mobile 手机号 [ require true ]
     * @support  string $province 省 [ require true ]
     * @support  string $city 市 [ require true ]
     * @support  string $district 区 [ require true ]
     * @support  string $address 地址 [ require true ]
     * @support  array $items 子单 [ require true ]
     * @support  mixed $item  [ require false ]
     * @support  int $createdBy 创建人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createRetailUnsale () {
        return self::getClass()->createRetailUnsale([
        ]);
    }

    /**
     * cancelRetailUnsale
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelRetailUnsale () {
        return self::getClass()->cancelRetailUnsale();
    }

    /**
     * getList
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * searchRetailUnsale
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchRetailUnsale () {
        return self::getClass()->searchRetailUnsale();
    }

    /**
     * getDetail
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetail () {
        return self::getClass()->getDetail();
    }

    /**
     * 领用单重推
     *
     * @support  array $unsaleIds ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function pushToGwall () {
        return self::getClass()->pushToGwall([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseRetailUnsale');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseRetailUnsale');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}