<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListPageByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListTagByParams(array $params)
 * @method getFirstByParams(array $params)
 * @method operationOrderByParams(array $params)
 */
class ReceiveExceptionOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 工单列表列表
     *
     * @support  int $store_id 门店id [ require false ]
     * @support  string $receive_no 收货单号 [ require false ]
     * @support  int $sku_id skuId [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $to_storage_id 收货方 [ require false ]
     * @support  int $from_storage_id 发货方 [ require false ]
     * @support  int $delivery_by 发货人 [ require false ]
     * @support  array $receive_item_ids 收货单子单id [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 工单列表列表
     *
     * @support  int $store_id 门店id [ require false ]
     * @support  string $receive_no 收货单号 [ require false ]
     * @support  int $sku_id skuId [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @support  string $status 异常类型 [ require false ]
     * @support  int $to_storage_id 收货方 [ require false ]
     * @support  int $from_storage_id 发货方 [ require false ]
     * @support  array $receive_item_ids 收货单子单id [ require false ]
     * @support  int $delivery_by 发货人 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList([
        ]);
    }

    /**
     * 获取状态标签
     *
     * @support  int $store_id 门店id [ require false ]
     * @support  string $receive_no 收货单号 [ require false ]
     * @support  int $sku_id skuId [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $to_storage_id 收货方 [ require false ]
     * @support  int $from_storage_id 发货方 [ require false ]
     * @support  int $delivery_by 发货人 [ require false ]
     * @support  array $receive_item_ids 收货单子单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListTag () {
        return self::getClass()->getListTag([
        ]);
    }

    /**
     * 工单详情
     *
     * @param  int $id  [ require true ]
     * @support  int $store_id 门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFirst (int $id) {
        return self::getClass()->getFirst([
            "id" => $id,
        ]);
    }

    /**
     * 操作工单
     *
     * @param  int $id  [ require true ]
     * @support  int $store_id 门店id [ require false ]
     * @support  string $operation_status 操作类型 [ require false ]
     * @support  string $handle_remark 操作人备注 [ require false ]
     * @support  array $send_address 发货地址 [ require false ]
     * @support  array $receive_address 收货地址 [ require false ]
     * @support  int $to_storage_id 收货仓库 [ require false ]
     * @support  int $reissue_number 补发数量 [ require false ]
     * @support  int $operation_by 操作人 [ require false ]
     * @support  int $return_num 退货数量 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function operationOrder (int $id) {
        return self::getClass()->operationOrder([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'ReceiveExceptionOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'ReceiveExceptionOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}