<?php
namespace Mainto\Bridge\Enums\HimoSupplyChain;

class ReceiveExceptionOrderStatusEnum {
    /**
     * 待发货人处理
     */
    const SENDER = 'sender';
    /**
     * 待门店处理
     */
    const STORE = 'store';
    /**
     * 待总仓处理
     */
    const WMS = 'wms';
    /**
     * 待发货人收货
     */
    const SENDER_RECEIVE = 'sender_receive';
    /**
     * 待门店收货
     */
    const STORE_RECEIVE = 'store_receive';
    /**
     * 完结
     */
    const END = 'end';
    /**
     * 驳回
     */
    const REJECT = 'reject';
    /**
     * 撤回
     */
    const REVOKE = 'revoke';
    /**
     * 列表展示数量的标签
     */
    const COUNT_SHOW = [0 => 'sender',1 => 'store',2 => 'sender_receive',3 => 'store_receive'];
    const TAG_MAP = ['all' => ['value' => '全部','count' => 0,'is_show' => false],'store_receive' => ['value' => '待门店收货','count' => 0,'is_show' => true],'sender_receive' => ['value' => '待发货人收货','count' => 0,'is_show' => true],'store' => ['value' => '待门店处理','count' => 0,'is_show' => true],'sender' => ['value' => '待发货人处理','count' => 0,'is_show' => true],'wms' => ['value' => '待总仓发货','count' => 0,'is_show' => true],'end' => ['value' => '完结','count' => 0,'is_show' => false],'reject' => ['value' => '驳回','count' => 0,'is_show' => false]];
    const STATUS_MAP = ['store_receive' => '待门店收货','sender_receive' => '待发货人收货','store' => '待门店处理','sender' => '待发货人处理','end' => '完结','reject' => '驳回'];
}