<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBrandsByParams(array $params)
 * @method syncBrandByParams(array $params)
 */
class Brand {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取品牌s
     *
     * @param  string $name 名称 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBrands (string $name = '') {
        return self::getClass()->getBrands([
            "name" => $name,
        ]);
    }

    /**
     * 同步品牌信息
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $nsId ns的id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncBrand (string $name, int $nsId = 0) {
        return self::getClass()->syncBrand([
            "name" => $name,
            "nsId" => $nsId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Brand');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Brand');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}