<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListPageByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListTagByParams(array $params)
 * @method getFirstByParams(array $params)
 * @method createExceptionOrderByParams(array $params)
 * @method approveOrderByParams(array $params)
 * @method storeRevokeByParams(array $params)
 * @method storeOperationOrderByParams(array $params)
 * @method confirmOperationOrderByParams(array $params)
 */
class ReceiveExceptionOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 工单列表列表
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  string $receiveNo 收货单号 [ require false ]
     * @support  int $skuId skuId [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $toStorageId 收货方 [ require false ]
     * @support  int $fromStorageId 发货方 [ require false ]
     * @support  int $deliveryBy 发货人 [ require false ]
     * @support  array $receiveItemIds 收货单子单id [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getListPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 工单列表列表
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  string $receiveNo 收货单号 [ require false ]
     * @support  int $skuId skuId [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @support  string $status 异常类型 [ require false ]
     * @support  int $toStorageId 收货方 [ require false ]
     * @support  int $fromStorageId 发货方 [ require false ]
     * @support  array $receiveItemIds 收货单子单id [ require false ]
     * @support  int $deliveryBy 发货人 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList([
        ]);
    }

    /**
     * 获取状态标签
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  string $receiveNo 收货单号 [ require false ]
     * @support  int $skuId skuId [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $toStorageId 收货方 [ require false ]
     * @support  int $fromStorageId 发货方 [ require false ]
     * @support  int $deliveryBy 发货人 [ require false ]
     * @support  array $receiveItemIds 收货单子单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListTag () {
        return self::getClass()->getListTag([
        ]);
    }

    /**
     * 工单详情
     *
     * @param  int $id  [ require true ]
     * @support  int $storeId 门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFirst (int $id) {
        return self::getClass()->getFirst([
            "id" => $id,
        ]);
    }

    /**
     * 提交异常工单
     *
     * @support  int $receiveItemId 收货子单id [ require false ]
     * @support  array $images 异常图片 [ require false ]
     * @support  string $type 异常类型 [ require false ]
     * @support  string $storeRemark 门店描述 [ require false ]
     * @support  string $isApplyReissue 是否需要补发 [ require false ]
     * @support  int $applyReissueNum 补发数量 [ require false ]
     * @support  int $errorNum 异常数量 [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  int $createdBy 创建人 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createExceptionOrder () {
        return self::getClass()->createExceptionOrder([
        ]);
    }

    /**
     * 工单审核
     *
     * @param  int $id 工单id [ require true ]
     * @support  string $processType 操作类型 [ require false ]
     * @support  string $handleRemark 操作人备注 [ require false ]
     * @support  array $sendAddress 发货地址 [ require false ]
     * @support  array $receiveAddress 收货地址 [ require false ]
     * @support  int $toStorageId 补发仓库 [ require false ]
     * @support  int $fromStorageId 退货仓库 [ require false ]
     * @support  int $operationBy 操作人 [ require false ]
     * @support  int $returnNum 退货数量 [ require false ]
     * @support  int $closureNum 关闭数量 [ require false ]
     * @support  int $reissueNum 补发数量 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function approveOrder (int $id) {
        return self::getClass()->approveOrder([
            "id" => $id,
        ]);
    }

    /**
     * 门店撤销工单
     *
     * @param  int $id 工单id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @support  int $operationBy 操作人 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeRevoke (int $id, int $storeId) {
        return self::getClass()->storeRevoke([
            "id" => $id,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 门店操作工单
     *
     * @support  int $id 工单id [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @param  string $processType 操作类型 [ require true ]
     * @support  int $operationBy 操作人 [ require false ]
     * @support  string $code 退回单号 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeOperationOrder (string $processType) {
        return self::getClass()->storeOperationOrder([
            "processType" => $processType,
        ]);
    }

    /**
     * 门店操作工单
     *
     * @support  int $id 工单id [ require false ]
     * @param  string $processType 操作类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function confirmOperationOrder (string $processType) {
        return self::getClass()->confirmOperationOrder([
            "processType" => $processType,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'ReceiveExceptionOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'ReceiveExceptionOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}