<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReceiveLogListByParams(array $params)
 * @method getReceiveLogIdByParams(array $params)
 * @method getReceiveLogIdByUserAndStorageIdByParams(array $params)
 * @method getReceiveAddressLogByIdByParams(array $params)
 */
class ReceiveAddressLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取列表数据
     *
     * @support  array $ids 收货地址记录ids require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReceiveLogList () {
        return self::getClass()->getReceiveLogList();
    }

    /**
     * 获取id
     *
     * @support  string $user_name 收货人姓名 require false
     * @support  string $phone 收货人手机号 require false
     * @support  string $province 省份 require false
     * @support  string $city 市 require false
     * @support  string $area 区 require false
     * @support  string $address 详细地址 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getReceiveLogId () {
        return self::getClass()->getReceiveLogId();
    }

    /**
     * 根据收货人信息和仓库id获取收货地址id
     *
     * @param  int $storageId 收货仓库 [ require true ]
     * @param  array $userData 收货人信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReceiveLogIdByUserAndStorageId (int $storageId, array $userData = []) {
        return self::getClass()->getReceiveLogIdByUserAndStorageId([
            "storageId" => $storageId,
            "userData" => $userData,
        ]);
    }

    /**
     * 根据收货人信息和仓库id获取收货地址id
     *
     * @param  int $receiveAddressLogId 收货地址记录 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReceiveAddressLogById (int $receiveAddressLogId) {
        return self::getClass()->getReceiveAddressLogById([
            "receiveAddressLogId" => $receiveAddressLogId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'ReceiveAddressLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'ReceiveAddressLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}