<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchUpdateByParams(array $params)
 * @method updateByParams(array $params)
 * @method getModuleByParams(array $params)
 * @method searchReceiveLogisticByParams(array $params)
 */
class ReceiveLogistics {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量导入（excel导入更新)
     *
     * @support  array $items 快递单号列表 [ require true ]
     * @support  mixed $item  require false
     * @support  int $updateBy 更新人 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUpdate () {
        return self::getClass()->batchUpdate();
    }

    /**
     * 单个更新（在收货单中批量更新 创建或更新)
     *
     * @support  array $items 快递单号列表 require false
     * @support  mixed $item  require false
     * @support  int $updateBy 更新人 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 获取快递单模版数据
     *
     * @support  array $receiveItemIds 收货单子单单号列表 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getModule () {
        return self::getClass()->getModule();
    }

    /**
     * 快递单查询
     *
     * @support  array $receiveItemIds 收货单子单id require false
     * @support  array $receiveIds 收货单主单id require false
     * @support  string $expressNo 快递单号 require false
     * @throws  \Exception
     * @return  array
     */
    public static function searchReceiveLogistic () {
        return self::getClass()->searchReceiveLogistic();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'ReceiveLogistics');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'ReceiveLogistics');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}