<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getFirstCategoriesByParams(array $params)
 * @method getCategoriesByParams(array $params)
 * @method doAutoSetNoByParams(array $params)
 * @method autoSetNoByParams(array $params)
 * @method getCategoryByIdsByParams(array $params)
 */
class Category {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 得到第一级目录
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFirstCategories () {
        return self::getClass()->getFirstCategories();
    }

    /**
     * 得到目录列表
     *
     * @param  string $name 目录名 [ require true ]
     * @param  int $source 来源 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategories (string $name = '', int $source = 1) {
        return self::getClass()->getCategories([
            "name" => $name,
            "source" => $source,
        ]);
    }

    /**
     * 手动初始化每日单号
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function doAutoSetNo (string $date) {
        return self::getClass()->doAutoSetNo([
            "date" => $date,
        ]);
    }

    /**
     * 自动初始化每日单号
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSetNo () {
        return self::getClass()->autoSetNo();
    }

    /**
     * 根据ids 获取分类信息
     *
     * @param  array $ids 分类ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryByIds (array $ids) {
        return self::getClass()->getCategoryByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Category');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Category');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}