<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method batchCreateByParams(array $params)
 */
class PurchaseGroup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 集采列表
     *
     * @support  string $startAt start_at require false
     * @support  string $endAt end_at require false
     * @support  int $createBy 下单人工号 require false
     * @support  string $status 状态 require false
     * @support  string $type 集采类型:normal/excel require false
     * @support  string $purchaseType 采购类型 require false
     * @support  string $demandNo 需求单号 require false
     * @param  int $page page [ require true ]
     * @param  int $pageSize pageSize [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 20) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 创建集采
     *
     * @support  string $storeType 门店类型 require false
     * @support  array $storeIds 门店id数组 require false
     * @support  array $skuInfo 物料sku数组 require false
     * @support  string $purchaseType 采购类型 require false
     * @support  int $storageId 仓库id require false
     * @support  string $remark 下单原因 require false
     * @support  int $createBy 下单人 require false
     * @support  array $departmentInfo 部门信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 批量集采
     *
     * @param  array $createInfo 仓库信息 [ require true ]
     * @param  string $remark 采购备注 [ require true ]
     * @param  string $purchaseType 采购类型 [ require true ]
     * @param  int $createBy 创建人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (int $createBy, array $createInfo, string $purchaseType, string $remark = '') {
        return self::getClass()->batchCreate([
            "createBy" => $createBy,
            "createInfo" => $createInfo,
            "purchaseType" => $purchaseType,
            "remark" => $remark,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseGroup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseGroup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}