<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array $params)
 * @method skuBindTagByParams(array $params)
 * @method batchSkuBindTagByParams(array $params)
 */
class ProductTagBindSku {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取标签下绑定的产品
     *
     * @support  int $productTagId 标签id require false
     * @support  int $skuId skuId require false
     * @support  array $productTagIds 标签ids require false
     * @support  array $skuIds skuIds require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 物料sku  绑定标签
     *
     * @param  int $skuId skuid [ require true ]
     * @param  array $productTagIds 标签Ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function skuBindTag (int $skuId, array $productTagIds = []) {
        return self::getClass()->skuBindTag([
            "skuId" => $skuId,
            "productTagIds" => $productTagIds,
        ]);
    }

    /**
     * 物料sku 批量绑定 绑定标签
     *
     * @param  array $binData 数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSkuBindTag (array $binData) {
        return self::getClass()->batchSkuBindTag([
            "binData" => $binData,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'ProductTagBindSku');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'ProductTagBindSku');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}