<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPurchaseRefundByParams(array $params)
 * @method submitPurchaseRefundByParams(array $params)
 * @method getItemsByParams(array $params)
 * @method getListPaginationByParams(array $params)
 * @method getListByParams(array $params)
 */
class PurchaseRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款单创建
     *
     * @support  int $noticeId 应付款单号 require false
     * @support  int $orderId 采购单号 require false
     * @support  int $advanceId 预付款单id require false
     * @support  int $returnId 退货单id require false
     * @support  int $supplierId 供应商id [ require true ]
     * @support  int $createdBy 创建人 require false
     * @support  array $items 子单 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchaseRefund () {
        return self::getClass()->createPurchaseRefund();
    }

    /**
     * 退款单完成
     *
     * @support  int $refundId 退款单id [ require true ]
     * @support  int $updatedBy 操作人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitPurchaseRefund () {
        return self::getClass()->submitPurchaseRefund();
    }

    /**
     * getItems
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getItems () {
        return self::getClass()->getItems();
    }

    /**
     * getListPagination
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getListPagination () {
        return self::getClass()->getListPagination();
    }

    /**
     * getList
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}